/*
 * Decompiled with CFR 0.152.
 */
package mb.log.stream;

import java.io.OutputStream;
import java.io.PrintWriter;
import mb.log.api.Logger;
import mb.log.api.LoggerFactory;
import mb.log.stream.StringFormatter;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StreamLoggerFactory
implements LoggerFactory {
    private final @Nullable PrintWriter errorWriter;
    private final @Nullable PrintWriter warnWriter;
    private final @Nullable PrintWriter infoWriter;
    private final @Nullable PrintWriter debugWriter;
    private final @Nullable PrintWriter traceWriter;

    public StreamLoggerFactory(@Nullable PrintWriter errorWriter, @Nullable PrintWriter warnWriter, @Nullable PrintWriter infoWriter, @Nullable PrintWriter debugWriter, @Nullable PrintWriter traceWriter) {
        this.errorWriter = errorWriter;
        this.warnWriter = warnWriter;
        this.infoWriter = infoWriter;
        this.debugWriter = debugWriter;
        this.traceWriter = traceWriter;
    }

    public static StreamLoggerFactory stdOutErrors() {
        return StreamLoggerFactory.errors(System.out);
    }

    public static StreamLoggerFactory stdOutErrorsAndWarnings() {
        return StreamLoggerFactory.errorsAndWarnings(System.out);
    }

    public static StreamLoggerFactory stdOutNonVerbose() {
        return StreamLoggerFactory.nonVerbose(System.out);
    }

    public static StreamLoggerFactory stdOutVerbose() {
        return StreamLoggerFactory.verbose(System.out);
    }

    public static StreamLoggerFactory stdOutVeryVerbose() {
        return StreamLoggerFactory.veryVerbose(System.out);
    }

    public static StreamLoggerFactory stdErrErrors() {
        return StreamLoggerFactory.errors(System.err);
    }

    public static StreamLoggerFactory stdErrErrorsAndWarnings() {
        return StreamLoggerFactory.errorsAndWarnings(System.err);
    }

    public static StreamLoggerFactory stdErrNonVerbose() {
        return StreamLoggerFactory.nonVerbose(System.err);
    }

    public static StreamLoggerFactory stdErrVerbose() {
        return StreamLoggerFactory.verbose(System.err);
    }

    public static StreamLoggerFactory stdErrVeryVerbose() {
        return StreamLoggerFactory.veryVerbose(System.err);
    }

    public static StreamLoggerFactory errors(OutputStream out) {
        return new StreamLoggerFactory(StreamLoggerFactory.newPrintWriter(out), null, null, null, null);
    }

    public static StreamLoggerFactory errorsAndWarnings(OutputStream out) {
        return new StreamLoggerFactory(StreamLoggerFactory.newPrintWriter(out), StreamLoggerFactory.newPrintWriter(out), null, null, null);
    }

    public static StreamLoggerFactory nonVerbose(OutputStream out) {
        return new StreamLoggerFactory(StreamLoggerFactory.newPrintWriter(out), StreamLoggerFactory.newPrintWriter(out), StreamLoggerFactory.newPrintWriter(out), null, null);
    }

    public static StreamLoggerFactory verbose(OutputStream out) {
        return new StreamLoggerFactory(StreamLoggerFactory.newPrintWriter(out), StreamLoggerFactory.newPrintWriter(out), StreamLoggerFactory.newPrintWriter(out), StreamLoggerFactory.newPrintWriter(out), null);
    }

    public static StreamLoggerFactory veryVerbose(OutputStream out) {
        return new StreamLoggerFactory(StreamLoggerFactory.newPrintWriter(out), StreamLoggerFactory.newPrintWriter(out), StreamLoggerFactory.newPrintWriter(out), StreamLoggerFactory.newPrintWriter(out), StreamLoggerFactory.newPrintWriter(out));
    }

    private static PrintWriter newPrintWriter(OutputStream out) {
        return new PrintWriter(out, true);
    }

    @Override
    public StreamLogger create(String name) {
        return new StreamLogger();
    }

    @Override
    public StreamLogger create(Class<?> clazz) {
        return new StreamLogger();
    }

    public class StreamLogger
    implements Logger {
        @Override
        public boolean isTraceEnabled() {
            return StreamLoggerFactory.this.traceWriter != null;
        }

        @Override
        public void trace(String format, Object ... args) {
            if (StreamLoggerFactory.this.traceWriter == null) {
                return;
            }
            StreamLoggerFactory.this.traceWriter.println(StringFormatter.format(format, args));
        }

        @Override
        public void trace(String format, Throwable cause, Object ... args) {
            if (StreamLoggerFactory.this.traceWriter == null) {
                return;
            }
            StreamLoggerFactory.this.traceWriter.println(StringFormatter.format(format, args));
            StreamLoggerFactory.this.traceWriter.println(cause);
        }

        @Override
        public boolean isDebugEnabled() {
            return StreamLoggerFactory.this.debugWriter != null;
        }

        @Override
        public void debug(String format, Object ... args) {
            if (StreamLoggerFactory.this.debugWriter == null) {
                return;
            }
            StreamLoggerFactory.this.debugWriter.println(StringFormatter.format(format, args));
        }

        @Override
        public void debug(String format, Throwable cause, Object ... args) {
            if (StreamLoggerFactory.this.debugWriter == null) {
                return;
            }
            StreamLoggerFactory.this.debugWriter.println(StringFormatter.format(format, args));
            StreamLoggerFactory.this.debugWriter.println(cause);
        }

        @Override
        public boolean isInfoEnabled() {
            return StreamLoggerFactory.this.infoWriter != null;
        }

        @Override
        public void info(String format, Object ... args) {
            if (StreamLoggerFactory.this.infoWriter == null) {
                return;
            }
            StreamLoggerFactory.this.infoWriter.println(StringFormatter.format(format, args));
        }

        @Override
        public void info(String format, Throwable cause, Object ... args) {
            if (StreamLoggerFactory.this.infoWriter == null) {
                return;
            }
            StreamLoggerFactory.this.infoWriter.println(StringFormatter.format(format, args));
            StreamLoggerFactory.this.infoWriter.println(cause);
        }

        @Override
        public boolean isWarnEnabled() {
            return StreamLoggerFactory.this.warnWriter != null;
        }

        @Override
        public void warn(String format, Object ... args) {
            if (StreamLoggerFactory.this.warnWriter == null) {
                return;
            }
            StreamLoggerFactory.this.warnWriter.println(StringFormatter.format(format, args));
        }

        @Override
        public void warn(String format, Throwable cause, Object ... args) {
            if (StreamLoggerFactory.this.warnWriter == null) {
                return;
            }
            StreamLoggerFactory.this.warnWriter.println(StringFormatter.format(format, args));
            StreamLoggerFactory.this.warnWriter.println(cause);
        }

        @Override
        public boolean isErrorEnabled() {
            return StreamLoggerFactory.this.errorWriter != null;
        }

        @Override
        public void error(String format, Object ... args) {
            if (StreamLoggerFactory.this.errorWriter == null) {
                return;
            }
            StreamLoggerFactory.this.errorWriter.println(StringFormatter.format(format, args));
        }

        @Override
        public void error(String format, Throwable cause, Object ... args) {
            if (StreamLoggerFactory.this.errorWriter == null) {
                return;
            }
            StreamLoggerFactory.this.errorWriter.println(StringFormatter.format(format, args));
            StreamLoggerFactory.this.errorWriter.println(cause);
        }
    }
}

