/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter.patterns;

import com.oracle.truffle.api.frame.VirtualFrame;
import mb.flowspec.runtime.interpreter.patterns.PatternNode;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.util.TermUtils;

public class TermPatternNode
extends PatternNode {
    private final String consName;
    private final PatternNode[] childPatterns;

    public TermPatternNode(String consName, PatternNode[] childPatterns) {
        this.consName = consName;
        this.childPatterns = childPatterns;
    }

    @Override
    public boolean matchGeneric(VirtualFrame frame, Object value) {
        if (!(value instanceof IStrategoTerm) || !TermUtils.isAppl((IStrategoTerm)value)) {
            return false;
        }
        return this.matchAppl(frame, (IStrategoAppl)value);
    }

    private boolean matchAppl(VirtualFrame frame, IStrategoAppl value) {
        if (!value.getName().equals(this.consName) || value.getSubtermCount() != this.childPatterns.length) {
            return false;
        }
        boolean result = true;
        IStrategoTerm[] args = value.getAllSubterms();
        int i = 0;
        while (i < this.childPatterns.length) {
            result &= this.childPatterns[i].matchGeneric(frame, args[i]);
            ++i;
        }
        return result;
    }
}

