/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter.locals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import java.util.concurrent.locks.Lock;
import mb.flowspec.runtime.interpreter.locals.ReadVarNode;

@GeneratedBy(value=ReadVarNode.class)
public final class ReadVarNodeGen
extends ReadVarNode {
    private final FrameSlot slot;
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;

    private ReadVarNodeGen(FrameSlot slot) {
        this.slot = slot;
    }

    @Override
    protected FrameSlot getSlot() {
        return this.slot;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 1) != 0 && this.isInt(frameValue)) {
            return this.readInt(frameValue);
        }
        if ((state & 2) != 0 && this.isBoolean(frameValue)) {
            return this.readBoolean(frameValue);
        }
        if ((state & 4) != 0) {
            return this.readObject(frameValue);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
        int state = this.state_;
        if ((state & 4) != 0) {
            return ReadVarNodeGen.expectBoolean(this.executeGeneric(frameValue));
        }
        if ((state & 2) != 0 && this.isBoolean(frameValue)) {
            return this.readBoolean(frameValue);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return ReadVarNodeGen.expectBoolean(this.executeAndSpecialize(frameValue));
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int state = this.state_;
        if ((state & 4) != 0) {
            return ReadVarNodeGen.expectInteger(this.executeGeneric(frameValue));
        }
        if ((state & 1) != 0 && this.isInt(frameValue)) {
            return this.readInt(frameValue);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return ReadVarNodeGen.expectInteger(this.executeAndSpecialize(frameValue));
    }

    private Object executeAndSpecialize(VirtualFrame frameValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if ((exclude & 1) == 0 && this.isInt(frameValue)) {
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                Integer n = this.readInt(frameValue);
                return n;
            }
            if ((exclude & 2) == 0 && this.isBoolean(frameValue)) {
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                Boolean bl = this.readBoolean(frameValue);
                return bl;
            }
            this.exclude_ = exclude |= 3;
            state &= 0xFFFFFFFC;
            this.state_ = state |= 4;
            lock.unlock();
            hasLock = false;
            Object object = this.readObject(frameValue);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    private static boolean expectBoolean(Object value) throws UnexpectedResultException {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new UnexpectedResultException(value);
    }

    private static int expectInteger(Object value) throws UnexpectedResultException {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static ReadVarNode create(FrameSlot slot) {
        return new ReadVarNodeGen(slot);
    }
}

