/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter.expressions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import java.util.concurrent.locks.Lock;
import mb.flowspec.runtime.interpreter.expressions.ExpressionNode;
import mb.flowspec.runtime.interpreter.expressions.OrNode;

@GeneratedBy(value=OrNode.class)
public final class OrNodeGen
extends OrNode {
    @Node.Child
    private ExpressionNode left_;
    @Node.Child
    private ExpressionNode right_;
    @CompilerDirectives.CompilationFinal
    private int state_;

    private OrNodeGen(ExpressionNode left, ExpressionNode right) {
        this.left_ = left;
        this.right_ = right;
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 2) == 0 && state != 0) {
            return this.executeBoolean_boolean_boolean0(frameValue, state);
        }
        return this.executeBoolean_generic1(frameValue, state);
    }

    private boolean executeBoolean_boolean_boolean0(VirtualFrame frameValue, int state) {
        boolean rightValue_;
        boolean leftValue_;
        try {
            leftValue_ = this.left_.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightValue = this.right_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightValue);
        }
        try {
            rightValue_ = this.right_.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftValue_, ex.getResult());
        }
        assert ((state & 1) != 0);
        return this.or(leftValue_, rightValue_);
    }

    private boolean executeBoolean_generic1(VirtualFrame frameValue, int state) {
        Object leftValue_ = this.left_.executeGeneric(frameValue);
        Object rightValue_ = this.right_.executeGeneric(frameValue);
        if ((state & 1) != 0 && leftValue_ instanceof Boolean) {
            boolean leftValue__ = (Boolean)leftValue_;
            if (rightValue_ instanceof Boolean) {
                boolean rightValue__ = (Boolean)rightValue_;
                return this.or(leftValue__, rightValue__);
            }
        }
        if ((state & 2) != 0) {
            return this.or(leftValue_, rightValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftValue_, rightValue_);
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        return this.executeBoolean(frameValue);
    }

    private boolean executeAndSpecialize(Object leftValue, Object rightValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (leftValue instanceof Boolean) {
                boolean leftValue_ = (Boolean)leftValue;
                if (rightValue instanceof Boolean) {
                    boolean rightValue_ = (Boolean)rightValue;
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.or(leftValue_, rightValue_);
                    return bl;
                }
            }
            this.state_ = state |= 2;
            lock.unlock();
            hasLock = false;
            boolean bl = this.or(leftValue, rightValue);
            return bl;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static OrNode create(ExpressionNode left, ExpressionNode right) {
        return new OrNodeGen(left, right);
    }
}

