/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter.expressions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import java.util.concurrent.locks.Lock;
import mb.flowspec.runtime.interpreter.expressions.EqualNode;
import mb.flowspec.runtime.interpreter.expressions.ExpressionNode;
import org.spoofax.interpreter.terms.IStrategoTerm;

@GeneratedBy(value=EqualNode.class)
public final class EqualNodeGen
extends EqualNode {
    @Node.Child
    private ExpressionNode left_;
    @Node.Child
    private ExpressionNode right_;
    @CompilerDirectives.CompilationFinal
    private int state_;

    private EqualNodeGen(ExpressionNode left, ExpressionNode right) {
        this.left_ = left;
        this.right_ = right;
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 0x1E) == 0 && state != 0) {
            return this.executeBoolean_int_int0(frameValue, state);
        }
        if ((state & 0x1D) == 0 && state != 0) {
            return this.executeBoolean_boolean_boolean1(frameValue, state);
        }
        return this.executeBoolean_generic2(frameValue, state);
    }

    private boolean executeBoolean_int_int0(VirtualFrame frameValue, int state) {
        int rightValue_;
        int leftValue_;
        try {
            leftValue_ = this.left_.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightValue = this.right_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightValue);
        }
        try {
            rightValue_ = this.right_.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftValue_, ex.getResult());
        }
        assert ((state & 1) != 0);
        return this.equal(leftValue_, rightValue_);
    }

    private boolean executeBoolean_boolean_boolean1(VirtualFrame frameValue, int state) {
        boolean rightValue_;
        boolean leftValue_;
        try {
            leftValue_ = this.left_.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightValue = this.right_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightValue);
        }
        try {
            rightValue_ = this.right_.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftValue_, ex.getResult());
        }
        assert ((state & 2) != 0);
        return this.equal(leftValue_, rightValue_);
    }

    private boolean executeBoolean_generic2(VirtualFrame frameValue, int state) {
        Object leftValue_ = this.left_.executeGeneric(frameValue);
        Object rightValue_ = this.right_.executeGeneric(frameValue);
        if ((state & 1) != 0 && leftValue_ instanceof Integer) {
            int n = (Integer)leftValue_;
            if (rightValue_ instanceof Integer) {
                int rightValue__ = (Integer)rightValue_;
                return this.equal(n, rightValue__);
            }
        }
        if ((state & 2) != 0 && leftValue_ instanceof Boolean) {
            boolean bl = (Boolean)leftValue_;
            if (rightValue_ instanceof Boolean) {
                boolean rightValue__ = (Boolean)rightValue_;
                return this.equal(bl, rightValue__);
            }
        }
        if ((state & 4) != 0 && leftValue_ instanceof String) {
            String string = (String)leftValue_;
            if (rightValue_ instanceof String) {
                String rightValue__ = (String)rightValue_;
                return this.equal(string, rightValue__);
            }
        }
        if ((state & 8) != 0 && leftValue_ instanceof IStrategoTerm) {
            IStrategoTerm iStrategoTerm = (IStrategoTerm)leftValue_;
            if (rightValue_ instanceof IStrategoTerm) {
                IStrategoTerm rightValue__ = (IStrategoTerm)rightValue_;
                return this.equal(iStrategoTerm, rightValue__);
            }
        }
        if ((state & 0x10) != 0 && leftValue_.getClass() != rightValue_.getClass()) {
            return this.equal(leftValue_, rightValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftValue_, rightValue_);
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        return this.executeBoolean(frameValue);
    }

    private boolean executeAndSpecialize(Object leftValue, Object rightValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (leftValue instanceof Integer) {
                int n = (Integer)leftValue;
                if (rightValue instanceof Integer) {
                    int rightValue_ = (Integer)rightValue;
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.equal(n, rightValue_);
                    return bl;
                }
            }
            if (leftValue instanceof Boolean) {
                boolean bl = (Boolean)leftValue;
                if (rightValue instanceof Boolean) {
                    boolean rightValue_ = (Boolean)rightValue;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    boolean bl2 = this.equal(bl, rightValue_);
                    return bl2;
                }
            }
            if (leftValue instanceof String) {
                String string = (String)leftValue;
                if (rightValue instanceof String) {
                    String rightValue_ = (String)rightValue;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.equal(string, rightValue_);
                    return bl;
                }
            }
            if (leftValue instanceof IStrategoTerm) {
                IStrategoTerm iStrategoTerm = (IStrategoTerm)leftValue;
                if (rightValue instanceof IStrategoTerm) {
                    IStrategoTerm rightValue_ = (IStrategoTerm)rightValue;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.equal(iStrategoTerm, rightValue_);
                    return bl;
                }
            }
            if (leftValue.getClass() != rightValue.getClass()) {
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                boolean bl = this.equal(leftValue, rightValue);
                return bl;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static EqualNode create(ExpressionNode left, ExpressionNode right) {
        return new EqualNodeGen(left, right);
    }
}

