/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.sql.docgen;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.sql.OracleXMLSQLException;
import oracle.xml.sql.docgen.OracleXMLDocGen;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class OracleXMLDocGenString
extends OracleXMLDocGen {
    private StringBuffer xmlBody = null;
    static final int MAX_CHUNK_SIZE = 4096;
    private StringBuffer xmlHead = null;
    private StringBuffer xmlString = null;
    private XSLProcessor xslp = null;
    private XSLStylesheet xslt = null;
    Hashtable namespaces = null;
    private static final String WSPACE = " ";
    private static final String WSPACE3 = "   ";
    private static final String LPAREN = "<";
    private static final String LPAREN_WQMARK = "<?";
    private static final String LPAREN_WSLASH = "</";
    private static final String WSPACE_INDENT1 = "   ";
    private static final String WSPACE_INDENT2 = "      ";
    private static final String WSPACE_INDENT3 = "         ";
    private static final String WSPACE_INDENT4 = "            ";
    private static final String RPAREN = ">\n";
    private static final String RPAREN_WQMARK = "?>\n";
    private static final String RPAREN_WSLASH = "/>\n";
    private static final String EQUAL_QUOTE = "=\"";
    private static final String QUOTE = "\"";
    private int level = 0;
    private int entryLevel = 0;
    static final int UNINITIALIZED_STATE = 0;
    static final int NEWELEMENT_STATE = 1;
    static final int ENDELEMENT_STATE = 2;
    static final int ADDTEXTVALUE_STATE = 3;
    static final int ADDATTRIBUTE_STATE = 4;
    private int docState = 0;
    private boolean isFragment = false;

    @Override
    public void createNewDocument(boolean bl) {
        if (this.xmlHead == null || bl) {
            this.xmlString = this.xmlHead = new StringBuffer(20000);
            this.xmlBody = new StringBuffer(20000);
        }
        if (bl) {
            this.level = 0;
            this.docState = 0;
        }
    }

    @Override
    public void createProcessingInstruction(String string, String string2) {
        if (this.isFragment) {
            return;
        }
        this.xmlString.append(LPAREN_WQMARK);
        this.xmlString.append(string);
        this.xmlString.append(WSPACE);
        this.xmlString.append(string2);
        this.xmlString.append(RPAREN_WQMARK);
    }

    @Override
    public void setVersion(String string) {
        if (this.isFragment) {
            return;
        }
        if (this.encoding == null) {
            this.createProcessingInstruction("xml", "version = '" + string + "'");
        } else {
            this.createProcessingInstruction("xml", "version = '" + string + "' " + "encoding = '" + this.encoding + "'");
        }
    }

    @Override
    public Object startNewElement(String string) {
        if (this.docState == 4 || this.docState == 1) {
            this.xmlString.append(RPAREN);
            this.docState = 2;
        }
        this.addIndentToString(this.level);
        this.xmlString.append(LPAREN);
        this.xmlString.append(string);
        ++this.level;
        this.docState = 1;
        return string;
    }

    @Override
    public void addTextValue(String string, boolean bl) {
        this.checkLegalXMLChars(string);
        this.xmlString.append(">");
        if (string != null) {
            if (bl) {
                this.convertString(this.xmlString, string);
            } else {
                this.xmlString.append(string);
            }
        }
        this.docState = 3;
    }

    @Override
    public void addTextValue(Reader reader, boolean bl) throws IOException {
        char[] cArray = new char[4096];
        this.xmlString.append(">");
        if (reader != null) {
            int n;
            while ((n = reader.read(cArray)) != -1) {
                String string = new String(cArray, 0, n);
                this.checkLegalXMLChars(string);
                if (bl) {
                    this.convertString(this.xmlString, string);
                    continue;
                }
                this.xmlString.append(string);
            }
        }
        this.docState = 3;
    }

    private void convertString(StringBuffer stringBuffer, String string) {
        int n = 0;
        int n2 = string.length();
        block6: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c != '&' && c != '<' && c != '>' && c != '\"') continue;
            stringBuffer.append(string.substring(n, i));
            n = i + 1;
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                }
            }
        }
        if (n < n2) {
            stringBuffer.append(string.substring(n));
        }
    }

    @Override
    public void endElement(Object object) {
        String string = (String)object;
        --this.level;
        if (this.level - this.entryLevel == 0 && this.namespaces != null) {
            String string2 = null;
            Enumeration enumeration = this.namespaces.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                this.xmlHead.append(WSPACE);
                this.xmlHead.append("xmlns");
                this.xmlHead.append(":");
                this.xmlHead.append(string2);
                this.xmlHead.append(EQUAL_QUOTE);
                this.xmlHead.append(this.namespaces.get(string2));
                this.xmlHead.append(QUOTE);
            }
        }
        if (this.docState == 4 || this.docState == 1) {
            this.xmlString.append(RPAREN_WSLASH);
        } else {
            if (this.docState != 3) {
                this.addIndentToString(this.level);
            }
            this.xmlString.append(LPAREN_WSLASH);
            this.xmlString.append(string);
            this.xmlString.append(RPAREN);
        }
        this.docState = 2;
    }

    @Override
    public void addAttribute(String string, String string2) {
        this.checkLegalXMLChars(string2);
        this.xmlString.append(WSPACE);
        this.xmlString.append(string);
        this.xmlString.append(EQUAL_QUOTE);
        this.convertString(this.xmlString, string2);
        this.xmlString.append(QUOTE);
        if (string == "xmlns") {
            this.xmlString = this.xmlBody;
        }
    }

    @Override
    public String getXMLDocumentString() {
        String string = this.xmlHead.append(this.xmlBody.toString()).toString();
        if (this.xslt == null) {
            return string;
        }
        StringWriter stringWriter = new StringWriter();
        try {
            DOMParser dOMParser = new DOMParser();
            dOMParser.setErrorStream((OutputStream)System.err);
            dOMParser.showWarnings(false);
            dOMParser.setPreserveWhitespace(false);
            StringReader stringReader = new StringReader(string);
            dOMParser.parse((Reader)stringReader);
            ((Reader)stringReader).close();
            XMLDocument xMLDocument = dOMParser.getDocument();
            this.xslp.processXSL(this.xslt, xMLDocument, new PrintWriter(stringWriter));
            return stringWriter.toString();
        }
        catch (Exception exception) {
            exception.fillInStackTrace();
            throw new OracleXMLSQLException(exception);
        }
    }

    private void addIndentToString(int n) {
        switch (n) {
            case 0: {
                return;
            }
            case 1: {
                this.xmlString.append("   ");
                return;
            }
            case 2: {
                this.xmlString.append(WSPACE_INDENT2);
                return;
            }
            case 3: {
                this.xmlString.append(WSPACE_INDENT3);
                return;
            }
            case 4: {
                this.xmlString.append(WSPACE_INDENT4);
                return;
            }
        }
        for (int i = 0; i < n / 4; ++i) {
            this.addIndentToString(4);
        }
        this.addIndentToString(n % 4);
    }

    @Override
    public void appendDTD(String string) {
        this.xmlString.append(string);
    }

    @Override
    public void insertXMLFragment(Reader reader) throws IOException, XMLParseException, SAXException {
        String string;
        boolean bl = true;
        if (this.docState == 4 || this.docState == 1) {
            this.xmlString.append(RPAREN);
            this.docState = 2;
        }
        if (reader == null) {
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((string = bufferedReader.readLine()) != null) {
            if (bl && string.startsWith("<?xml ")) {
                bl = false;
                if (string.endsWith("?>")) continue;
                int n = string.lastIndexOf("?>");
                this.addIndentToString(this.level);
                this.xmlString.append(string.substring(n + 2));
                this.xmlString.append("\n");
                continue;
            }
            this.addIndentToString(this.level);
            this.xmlString.append(string);
            this.xmlString.append("\n");
            bl = false;
        }
        this.addIndentToString(this.level - 1);
        this.docState = 3;
    }

    @Override
    public void insertXMLFragment(Document document) {
        if (this.docState == 4 || this.docState == 1) {
            this.xmlString.append(RPAREN);
            this.docState = 2;
        }
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            ((XMLDocument)document).print(printWriter);
            printWriter.flush();
            this.xmlString = this.xmlString.append(stringWriter.toString());
        }
        catch (IOException iOException) {
            iOException.fillInStackTrace();
            throw new OracleXMLSQLException(iOException);
        }
    }

    @Override
    public Object getDocFragment() {
        if (!this.isFragment) {
            return null;
        }
        return this.xmlHead.toString() + this.xmlBody.toString();
    }

    @Override
    public OracleXMLDocGen newDocGenDoc(boolean bl) {
        OracleXMLDocGenString oracleXMLDocGenString = new OracleXMLDocGenString();
        if (this.encoding != null) {
            oracleXMLDocGenString.setEncoding(this.encoding);
        }
        oracleXMLDocGenString.createNewDocument(false);
        oracleXMLDocGenString.isFragment = bl;
        if (bl) {
            oracleXMLDocGenString.entryLevel = oracleXMLDocGenString.level = this.level;
        }
        return oracleXMLDocGenString;
    }

    @Override
    public void docAppend(OracleXMLDocGen oracleXMLDocGen) {
        if (this.isFragment) {
            return;
        }
        if (this.docState == 4 || this.docState == 1) {
            this.xmlString.append(RPAREN);
            this.docState = 2;
        }
        this.xmlString.append((String)oracleXMLDocGen.getDocFragment());
    }

    @Override
    public String addNamespace(String string, String string2) {
        if (this.namespaces == null) {
            this.namespaces = new Hashtable(4);
        }
        return this.namespaces.put(string, string2);
    }

    @Override
    public boolean supportMetatype(int n) {
        return n == 1;
    }

    @Override
    public boolean applyStylesheet(XSLProcessor xSLProcessor, XSLStylesheet xSLStylesheet) {
        this.xslp = xSLProcessor;
        this.xslt = xSLStylesheet;
        return true;
    }
}

