/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.sql.docgen;

import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.sql.OracleXMLSQLException;
import oracle.xml.sql.docgen.OracleXMLDocGen;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class OracleXMLDocGenSAX
extends OracleXMLDocGen {
    static final int MAX_CHUNK_SIZE = 4096;
    private static final char[] LESS_THAN_REP = new char[]{'&', 'l', 't', ';'};
    private static final char[] GREATER_THAN_REP = new char[]{'&', 'g', 't', ';'};
    private static final char[] AMP_REP = new char[]{'&', 'a', 'm', 'p', ';'};
    private static final char[] QUOTE_REP = new char[]{'&', 'q', 'u', 'o', 't', ';'};
    ContentHandler doc = null;
    String curElem = null;
    AttributesImpl curAttrs = null;
    char[] curText = null;
    int curLen = 0;
    Reader curStream = null;
    int depth = 0;
    Hashtable namespaces = null;

    public OracleXMLDocGenSAX() {
    }

    public OracleXMLDocGenSAX(ContentHandler contentHandler) {
        this.setContentHandler(contentHandler);
    }

    public void setContentHandler(ContentHandler contentHandler) {
        if (contentHandler == null) {
            throw new OracleXMLSQLException(this.msg.getMessage0("XSUE-0018"));
        }
        this.doc = contentHandler;
    }

    @Override
    public void createNewDocument(boolean bl) {
        try {
            this.doc.startDocument();
        }
        catch (SAXException sAXException) {
            throw new OracleXMLSQLException(sAXException.getMessage());
        }
    }

    @Override
    public void endDocument() {
        this.curElem = null;
        this.curAttrs = null;
        this.curText = null;
        try {
            this.doc.endDocument();
        }
        catch (SAXException sAXException) {
            throw new OracleXMLSQLException(sAXException.getMessage());
        }
    }

    @Override
    public void createProcessingInstruction(String string, String string2) {
        this.checkLegalXMLChars(string2);
        this.piT = string;
        this.piD = string2;
        try {
            this.doc.processingInstruction(string, string2);
        }
        catch (SAXException sAXException) {
            throw new OracleXMLSQLException(sAXException.getMessage());
        }
    }

    @Override
    public void setVersion(String string) {
        this.version = string;
    }

    @Override
    public void setEncoding(String string) {
        this.encoding = string == null || string.length() == 0 ? null : string;
    }

    @Override
    public Object startNewElement(String string) {
        ++this.depth;
        try {
            if (this.curElem != null) {
                this.doc.startElement("", this.curElem, this.curElem, this.curAttrs);
                if (this.curText != null) {
                    this.checkLegalXMLChars(new String(this.curText));
                    this.doc.characters(this.curText, 0, this.curText.length);
                    this.curText = null;
                } else if (this.curStream != null) {
                    int n;
                    char[] cArray = new char[4096];
                    while ((n = this.curStream.read(cArray)) != -1) {
                        this.checkLegalXMLChars(new String(cArray));
                        this.doc.characters(cArray, 0, n);
                    }
                    this.curStream = null;
                }
            }
            this.curElem = string;
            this.curAttrs = new AttributesImpl();
        }
        catch (SAXException sAXException) {
            throw new OracleXMLSQLException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new OracleXMLSQLException(iOException.getMessage());
        }
        return string;
    }

    @Override
    public void addTextValue(String string, boolean bl) {
        if (string == null) {
            this.curText = null;
            this.curLen = 0;
            return;
        }
        this.checkLegalXMLChars(string);
        this.curText = string.toCharArray();
        this.curLen = this.curText.length;
    }

    @Override
    public void addTextValue(Reader reader, boolean bl) {
        this.curText = null;
        this.curLen = 0;
        this.curStream = reader;
    }

    private void convertString(String string) {
        int n = string.length();
        char[] cArray = null;
        this.curText = new char[2 * n];
        this.curLen = 0;
        block6: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case '<': {
                    this.append(LESS_THAN_REP);
                    continue block6;
                }
                case '>': {
                    this.append(GREATER_THAN_REP);
                    continue block6;
                }
                case '&': {
                    this.append(AMP_REP);
                    continue block6;
                }
                case '\"': {
                    this.append(QUOTE_REP);
                    continue block6;
                }
                default: {
                    if (this.curLen >= this.curText.length) {
                        cArray = new char[2 * this.curText.length];
                        System.arraycopy(this.curText, 0, cArray, 0, this.curLen);
                        this.curText = cArray;
                    }
                    this.curText[this.curLen] = string.charAt(i);
                    ++this.curLen;
                }
            }
        }
    }

    private void append(char[] cArray) {
        if (this.curLen + cArray.length > this.curText.length) {
            int n;
            for (n = this.curText.length; this.curLen + cArray.length > n; n = 2 * n) {
            }
            char[] cArray2 = new char[n];
            System.arraycopy(this.curText, 0, cArray2, 0, this.curLen);
            this.curText = cArray2;
        }
        System.arraycopy(cArray, 0, this.curText, this.curLen, cArray.length);
        this.curLen += cArray.length;
    }

    @Override
    public void endElement(Object object) {
        try {
            if (this.curElem != null) {
                this.doc.startElement("", this.curElem, this.curElem, this.curAttrs);
                this.curElem = null;
                this.curAttrs = null;
                if (this.curText != null) {
                    this.checkLegalXMLChars(new String(this.curText));
                    this.doc.characters(this.curText, 0, this.curLen);
                    this.curText = null;
                    this.curLen = 0;
                } else if (this.curStream != null) {
                    int n;
                    char[] cArray = new char[4096];
                    while ((n = this.curStream.read(cArray)) != -1) {
                        this.checkLegalXMLChars(new String(cArray));
                        this.doc.characters(cArray, 0, n);
                    }
                    this.curStream = null;
                }
            }
            this.doc.endElement("", (String)object, (String)object);
            --this.depth;
            if (this.depth == 0) {
                this.endDocument();
            }
        }
        catch (SAXException sAXException) {
            throw new OracleXMLSQLException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new OracleXMLSQLException(iOException.getMessage());
        }
    }

    @Override
    public void addAttribute(String string, String string2) {
        this.checkLegalXMLChars(string2);
        this.curAttrs.addAttribute("", string, string, "string", string2);
    }

    @Override
    public void insertXMLFragment(Reader reader) throws IOException, XMLParseException, SAXException {
    }

    @Override
    public void insertXMLFragment(Document document) {
    }

    @Override
    public String getXMLDocumentString() {
        return this.doc.toString();
    }

    @Override
    public Object getDocFragment() {
        return null;
    }

    @Override
    public void appendDTD(String string) {
    }

    @Override
    public OracleXMLDocGen newDocGenDoc(boolean bl) {
        return null;
    }

    @Override
    public void docAppend(OracleXMLDocGen oracleXMLDocGen) {
    }

    @Override
    public String addNamespace(String string, String string2) {
        return null;
    }
}

