/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.sql.dataset;

import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import oracle.xml.sql.OracleXMLSQLException;
import oracle.xml.sql.core.OracleXMLConvert;
import oracle.xml.sql.dataset.OracleXMLDataSet;

public class OracleXMLDataSetGenJdbc
extends OracleXMLDataSet {
    public OracleXMLDataSetGenJdbc(Connection connection, ResultSet resultSet) throws SQLException {
        this.conn = connection;
        this.rset = resultSet;
        this.rsetIsExt = true;
        this.rmdata = this.rset.getMetaData();
        this.rsetVal = this.rset.next();
        this.isConsistent = true;
    }

    public OracleXMLDataSetGenJdbc(Connection connection, String string) throws SQLException {
        this.conn = connection;
        this.stmt = this.conn.prepareStatement(string);
        this.refreshDataSet();
    }

    public OracleXMLDataSetGenJdbc(Connection connection, Reader reader) throws Exception {
        this.conn = connection;
        String string = this.processSQLQuery(reader);
        this.stmt = this.conn.prepareStatement(string);
        if (this.bindPosHash != null) {
            this.isConsistent = false;
            return;
        }
        this.refreshDataSet();
    }

    public OracleXMLDataSetGenJdbc(Connection connection, Reader reader, Vector vector, Vector vector2) throws IOException, SQLException {
        this.conn = connection;
        if (vector != null) {
            String string = null;
            if (vector2 == null || vector.size() != vector2.size()) {
                throw new OracleXMLSQLException(this.msg.getMessage0("XSUE-0010"));
            }
            string = this.processSQLQuery(reader);
            if (vector.size() != this.bindPosHash.size()) {
                throw new OracleXMLSQLException(this.msg.getMessage0("XSUE-0011"));
            }
            this.stmt = this.conn.prepareStatement(string);
            for (int i = vector.size() - 1; i >= 0; --i) {
                this.bindValue((String)vector.elementAt(i), (String)vector2.elementAt(i));
            }
        } else {
            StringBuffer stringBuffer = OracleXMLConvert.ReaderToStrBuf(reader, null);
            this.stmt = this.conn.prepareStatement(stringBuffer.toString());
        }
        this.refreshDataSet();
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        if (this.rmdata == null) {
            this.refreshDataSet();
        }
        return this.getStandardTypecode(this.rmdata.getColumnType(n));
    }

    private int getStandardTypecode(int n) {
        if (n == 12 || n == -9 || n >= -7 && n <= 8 || n >= 91 && n <= 93 || n >= 2000 && n <= 2006) {
            return n;
        }
        return 1111;
    }

    @Override
    public void getStructMetaData(Object object, String[][] stringArray, Object[][] objectArray, int[][] nArray, int[][] nArray2, int[][] nArray3) throws SQLException {
        throw new OracleXMLSQLException("getStructMetaData:  " + this.msg.getMessage2("XSUE-0009", "OracleXMLDataSetGenJdbc", "OracleXMLDataSetExtJdbc"));
    }

    @Override
    public void getCollectionMetaData(Object object, Object[] objectArray, int[] nArray, int[] nArray2, int[] nArray3) throws SQLException {
        throw new OracleXMLSQLException("getCollectionMetaData:  " + this.msg.getMessage2("XSUE-0009", "OracleXMLDataSetGenJdbc", "OracleXMLDataSetExtJdbc"));
    }

    @Override
    public boolean fetchNextRow() throws SQLException {
        if (!this.isConsistent) {
            this.refreshDataSet();
        }
        if (this.rsetFirstTime) {
            this.rsetFirstTime = false;
            return this.rsetVal;
        }
        return this.rset.next();
    }

    @Override
    public Object[] getStructAttributes(Object object) throws SQLException {
        throw new OracleXMLSQLException("getStructAttributes:  " + this.msg.getMessage2("XSUE-0009", "OracleXMLDataSetGenJdbc", "OracleXMLDataSetExtJdbc"));
    }

    @Override
    public Object[] getCollectionValues(Object object) throws SQLException {
        throw new OracleXMLSQLException("getCollectionValues:  " + this.msg.getMessage2("XSUE-0009", "OracleXMLDataSetGenJdbc", "OracleXMLDataSetExtJdbc"));
    }

    @Override
    public boolean cursorFetchNextRow(Object object, int n) throws SQLException {
        throw new OracleXMLSQLException("cursorFetchNextRow:  " + this.msg.getMessage2("XSUE-0009", "OracleXMLDataSetGenJdbc", "OracleXMLDataSetExtJdbc"));
    }

    @Override
    public Object cursorGetColumnObject(Object object, int n) throws SQLException {
        throw new OracleXMLSQLException("cursorGetColumnObject:  " + this.msg.getMessage2("XSUE-0009", "OracleXMLDataSetGenJdbc", "OracleXMLDataSetExtJdbc"));
    }

    @Override
    public void cursorGetMetaData(Object object, String[][] stringArray, Object[][] objectArray, int[][] nArray, int[][] nArray2, int[][] nArray3) throws SQLException {
        throw new OracleXMLSQLException("cursorGetMetaData:  " + this.msg.getMessage2("XSUE-0009", "OracleXMLDataSetGenJdbc", "OracleXMLDataSetExtJdbc"));
    }

    @Override
    public void cursorClose(Object object) throws SQLException {
        throw new OracleXMLSQLException("cursorClose:  " + this.msg.getMessage2("XSUE-0009", "OracleXMLDataSetGenJdbc", "OracleXMLDataSetExtJdbc"));
    }
}

