/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.sql.dataset;

import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.regex.Pattern;
import oracle.xml.sql.OracleXMLSQLException;
import oracle.xml.sql.XSUMesg;
import oracle.xml.sql.core.OracleXMLConvert;

public abstract class OracleXMLDataSet {
    ResultSet rset;
    ResultSetMetaData rmdata;
    final XSUMesg msg = OracleXMLConvert.msg;
    SimpleDateFormat sdf = null;
    boolean rsetIsExt = false;
    boolean rsetFirstTime = true;
    boolean rsetVal = true;
    boolean isConsistent = false;
    Connection conn = null;
    private String connUser = null;
    PreparedStatement stmt = null;
    Hashtable bindPosHash = null;
    public long rowCount = 1L;
    private static final int PROCESS_SQL_QUERY_NORMAL = 0;
    private static final int PROCESS_SQL_QUERY_IN_QUOTED_STRING = 1;
    private static final int PROCESS_SQL_QUERY_IN_C_STYLE_COMMENT = 2;
    private static final int PROCESS_SQL_QUERY_IN_DASH_DASH_COMMENT = 3;

    public void close() throws SQLException {
        if (this.rset != null && !this.rsetIsExt) {
            this.rset.close();
        }
        if (this.stmt != null) {
            this.stmt.close();
        }
    }

    public void resetResultSet() {
        try {
            if (!this.isConsistent) {
                this.refreshDataSet();
                return;
            }
            this.rowCount = 1L;
            this.rsetFirstTime = true;
            if (this.rset.getType() != 1003) {
                this.rsetVal = this.rset.first();
                return;
            }
            if (this.rsetIsExt) {
                throw new OracleXMLSQLException(this.msg.getMessage0("XSUE-0103"));
            }
            this.rset = this.stmt.executeQuery();
            this.rsetVal = this.rset.next();
        }
        catch (SQLException sQLException) {
            try {
                this.close();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw new OracleXMLSQLException(sQLException);
        }
    }

    public void refreshDataSet() {
        try {
            if (!this.isConsistent) {
                this.rowCount = 1L;
                this.rset = this.stmt.executeQuery();
                this.rsetFirstTime = true;
            }
            if (this.rmdata == null) {
                this.rmdata = this.rset.getMetaData();
            }
            if (!this.isConsistent) {
                this.rsetVal = this.rset.next();
            }
            this.isConsistent = true;
        }
        catch (SQLException sQLException) {
            try {
                this.close();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw new OracleXMLSQLException(sQLException);
        }
    }

    public void bindValue(String string, String string2) {
        Integer n = null;
        try {
            if (this.bindPosHash != null) {
                n = (Integer)this.bindPosHash.get(string);
            }
            if (n == null) {
                throw new OracleXMLSQLException(this.msg.getMessage1("XSUE-0012", string));
            }
            if (string2 == null) {
                this.stmt.setNull(n, 12);
            } else {
                this.stmt.setString(n, string2);
            }
            this.isConsistent = false;
        }
        catch (SQLException sQLException) {
            throw new OracleXMLSQLException(sQLException);
        }
    }

    public void clearBindValues() {
        try {
            if (this.stmt != null) {
                this.stmt.clearParameters();
            }
        }
        catch (SQLException sQLException) {
            throw new OracleXMLSQLException(sQLException);
        }
    }

    public boolean isEmpty() {
        if (!this.isConsistent) {
            this.refreshDataSet();
        }
        return !this.rsetVal;
    }

    final String processSQLQuery(Reader reader) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.bindPosHash == null) {
            this.bindPosHash = new Hashtable(10);
        }
        try {
            int n = 0;
            int n2 = -1;
            int n3 = 0;
            int n4 = 0;
            int n5 = reader.read();
            while (n5 != -1) {
                if (n3 == 1) {
                    if (n5 == n4) {
                        n3 = 0;
                    }
                } else if (n3 == 2) {
                    if (n2 == 42 && n5 == 47) {
                        n3 = 0;
                    }
                } else if (n3 == 3) {
                    if (n5 == 10) {
                        n3 = 0;
                    }
                } else if (n5 == 39 || n5 == 34) {
                    n3 = 1;
                    n4 = (char)n5;
                } else if (n2 == 47 && n5 == 42) {
                    n3 = 2;
                } else if (n2 == 45 && n5 == 45) {
                    n3 = 3;
                } else if (n5 == 58) {
                    ++n;
                    stringBuffer.append('?');
                    object = new StringBuffer(32);
                    while (true) {
                        n2 = n5;
                        n5 = reader.read();
                        if (n5 == -1 || n5 == 44 || n5 == 32 || n5 == 124 || n5 == 41 || n5 == 10) break;
                        ((StringBuffer)object).append((char)n5);
                    }
                    if (((StringBuffer)object).length() == 0) {
                        throw new OracleXMLSQLException(this.msg.getMessage0("XSUE-0013"));
                    }
                    this.bindPosHash.put(((StringBuffer)object).toString(), new Integer(n));
                    if (n5 == -1) break;
                }
                stringBuffer.append((char)n5);
                n2 = n5;
                n5 = reader.read();
            }
            if (n == 0) {
                this.bindPosHash = null;
            }
        }
        catch (IOException iOException) {
            throw new OracleXMLSQLException(iOException);
        }
        String string = stringBuffer.toString();
        Pattern pattern = Pattern.compile("^\\s*((/\\*.*?\\*/\\s*)|(--[^\\n]*\\n\\s*))*\\s*", 32);
        String[] stringArray = pattern.split(string, 2);
        String string2 = stringArray[stringArray.length - 1];
        object = string2.split("\\W", 3);
        String string3 = object[0];
        if (string3.compareToIgnoreCase("SELECT") != 0) {
            throw new OracleXMLSQLException(this.msg.getMessage0("XSUE-0105"));
        }
        return string;
    }

    public int getPrecision(int n) throws SQLException {
        if (this.rmdata == null) {
            this.refreshDataSet();
        }
        return this.rmdata.getPrecision(n);
    }

    public int getScale(int n) throws SQLException {
        if (this.rmdata == null) {
            this.refreshDataSet();
        }
        return this.rmdata.getScale(n);
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        if (this.rmdata == null) {
            this.refreshDataSet();
        }
        return this.rmdata.getColumnDisplaySize(n);
    }

    public String getColumnName(int n) throws SQLException {
        if (this.rmdata == null) {
            this.refreshDataSet();
        }
        return this.rmdata.getColumnName(n);
    }

    public int getColumnType(int n) throws SQLException {
        if (this.rmdata == null) {
            this.refreshDataSet();
        }
        return this.rmdata.getColumnType(n);
    }

    public String getColumnLabel(int n) throws SQLException {
        if (this.rmdata == null) {
            this.refreshDataSet();
        }
        return this.rmdata.getColumnLabel(n);
    }

    public int isNullable(int n) throws SQLException {
        if (this.rmdata == null) {
            this.refreshDataSet();
        }
        return this.rmdata.isNullable(n);
    }

    public Object getColumnTypeObject(int n) throws SQLException {
        if (this.rmdata == null) {
            this.refreshDataSet();
        }
        return this.rmdata.getColumnTypeName(n);
    }

    public void setDateFormat(String string) {
        this.sdf = string == null ? null : new SimpleDateFormat(string);
    }

    public int getColumnCount() throws SQLException {
        if (this.rmdata == null) {
            this.refreshDataSet();
        }
        return this.rmdata.getColumnCount();
    }

    public String getConnUser() {
        try {
            if (this.connUser == null) {
                this.connUser = this.conn.getMetaData().getUserName();
            }
            return this.connUser;
        }
        catch (SQLException sQLException) {
            throw new OracleXMLSQLException(sQLException);
        }
    }

    public abstract void getStructMetaData(Object var1, String[][] var2, Object[][] var3, int[][] var4, int[][] var5, int[][] var6) throws SQLException;

    public String getTypesSchema(Object object) {
        try {
            String string = (String)object;
            String[] stringArray = new String[1];
            String[] stringArray2 = new String[]{null};
            stringArray[0] = null;
            OracleXMLConvert.parse(string, stringArray, stringArray2);
            if (stringArray[0] == null) {
                return this.getConnUser();
            }
            return stringArray[0];
        }
        catch (SQLException sQLException) {
            throw new OracleXMLSQLException(sQLException, "ERROR");
        }
    }

    public static String getTypesName(Object object) {
        try {
            String string = (String)object;
            String[] stringArray = new String[1];
            String[] stringArray2 = new String[]{null};
            stringArray[0] = null;
            OracleXMLConvert.parse(string, stringArray, stringArray2);
            return stringArray2[0];
        }
        catch (SQLException sQLException) {
            throw new OracleXMLSQLException(sQLException, "ERROR");
        }
    }

    public abstract void getCollectionMetaData(Object var1, Object[] var2, int[] var3, int[] var4, int[] var5) throws SQLException;

    public abstract boolean fetchNextRow() throws SQLException;

    public boolean skipNextRow() throws SQLException {
        return this.fetchNextRow();
    }

    public Object getObject(int n) throws SQLException {
        if (!this.isConsistent) {
            this.refreshDataSet();
        }
        return this.rset.getObject(n);
    }

    public void closeDsetList() throws SQLException {
    }

    public abstract Object[] getStructAttributes(Object var1) throws SQLException;

    public abstract Object[] getCollectionValues(Object var1) throws SQLException;

    public abstract boolean cursorFetchNextRow(Object var1, int var2) throws SQLException;

    public abstract Object cursorGetColumnObject(Object var1, int var2) throws SQLException;

    public abstract void cursorGetMetaData(Object var1, String[][] var2, Object[][] var3, int[][] var4, int[][] var5, int[][] var6) throws SQLException;

    public abstract void cursorClose(Object var1) throws SQLException;

    public String getScalarStrValue(Object object) throws SQLException {
        return object.toString();
    }

    public String getDateString(Object object) throws SQLException {
        if (this.sdf == null) {
            return object.toString();
        }
        return this.sdf.format((Date)object);
    }

    public static boolean isNumeric(int n) {
        return n == -6 || n == -5 || n >= 2 && n <= 8;
    }

    public static boolean isCHARic(int n) {
        return n == 1 || n == 12 || n == -15 || n == -9 || n == 2005;
    }

    public static boolean isString(int n) {
        return n == 1 || n == 12 || n == -15 || n == -9;
    }

    public boolean isNCHAR(int n) throws SQLException {
        return false;
    }
}

