/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.subversion.javahl.types.RevisionRange;
import org.apache.subversion.javahl.types.RevisionRangeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mergeinfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, List<RevisionRange>> mergeSources = new HashMap<String, List<RevisionRange>>();

    public Mergeinfo() {
    }

    public Mergeinfo(String mergeinfo) {
        this();
        this.loadFromMergeinfoProperty(mergeinfo);
    }

    public void addRevisions(String mergeSrc, List<RevisionRange> ranges) {
        for (RevisionRange range : ranges) {
            this.addRevisionRange(mergeSrc, range);
        }
    }

    public void addRevisions(String mergeSrc, RevisionRangeList ranges) {
        this.addRevisions(mergeSrc, ranges.getRanges());
    }

    public void addRevisionRange(String mergeSrc, RevisionRange range) {
        List<RevisionRange> revisions = this.getRevisions(mergeSrc);
        if (revisions == null) {
            revisions = new ArrayList<RevisionRange>();
        }
        revisions.add(range);
        this.setRevisionList(mergeSrc, revisions);
    }

    public Set<String> getPaths() {
        return this.mergeSources.keySet();
    }

    public List<RevisionRange> getRevisions(String mergeSrc) {
        if (mergeSrc == null) {
            return null;
        }
        return this.mergeSources.get(mergeSrc);
    }

    public List<RevisionRange> getRevisionRange(String mergeSrc) {
        return this.getRevisions(mergeSrc);
    }

    public RevisionRangeList getRevisionRangeList(String mergeSrc) {
        return new RevisionRangeList(this.getRevisionRange(mergeSrc));
    }

    public void loadFromMergeinfoProperty(String mergeinfo) {
        if (mergeinfo == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(mergeinfo, "\n");
        while (st.hasMoreTokens()) {
            this.parseMergeinfoLine(st.nextToken());
        }
    }

    private void parseMergeinfoLine(String line) {
        int colon = line.indexOf(58);
        if (colon > 0) {
            String pathElement = line.substring(0, colon);
            String revisions = line.substring(colon + 1);
            this.parseRevisions(pathElement, revisions);
        }
    }

    private void parseRevisions(String path, String revisions) {
        List<RevisionRange> rangeList = this.getRevisions(path);
        StringTokenizer st = new StringTokenizer(revisions, ",");
        while (st.hasMoreTokens()) {
            String revisionElement = st.nextToken();
            RevisionRange range = new RevisionRange(revisionElement);
            if (rangeList == null) {
                rangeList = new ArrayList<RevisionRange>();
            }
            rangeList.add(range);
        }
        if (rangeList != null) {
            this.setRevisionList(path, rangeList);
        }
    }

    private void setRevisionList(String mergeSrc, List<RevisionRange> range) {
        this.mergeSources.put(mergeSrc, range);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LogKind {
        eligible,
        merged;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Inheritance {
        explicit,
        inherited,
        nearest_ancestor;

    }
}

