/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.remote;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.SimpleTimeZone;
import org.apache.subversion.javahl.ISVNEditor;
import org.apache.subversion.javahl.callback.RemoteStatus;
import org.apache.subversion.javahl.types.Checksum;
import org.apache.subversion.javahl.types.NodeKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StatusEditor
implements ISVNEditor {
    protected RemoteStatus receiver = null;
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final SimpleTimeZone UTC = new SimpleTimeZone(2, "UTC");
    private static final String entryprop_uuid = "svn:entry:uuid";
    private static final String entryprop_author = "svn:entry:last-author";
    private static final String entryprop_revision = "svn:entry:committed-rev";
    private static final String entryprop_timestamp = "svn:entry:committed-date";
    private final GregorianCalendar entry_calendar = new GregorianCalendar(UTC, Locale.ROOT);
    private static final String wcprop_prefix = "svn:wc:";
    private static final String entryprop_prefix = "svn:entry:";

    StatusEditor(RemoteStatus receiver) {
        this.receiver = receiver;
    }

    protected void checkState() {
        if (this.receiver == null) {
            throw new IllegalStateException("Status editor is not active");
        }
    }

    @Override
    public void dispose() {
        if (this.receiver != null) {
            this.abort();
        }
    }

    @Override
    public void addDirectory(String relativePath, Iterable<String> children, Map<String, byte[]> properties, long replacesRevision) {
        this.checkState();
        this.receiver.addedDirectory(relativePath);
    }

    @Override
    public void addFile(String relativePath, Checksum checksum, InputStream contents, Map<String, byte[]> properties, long replacesRevision) {
        if (contents != null) {
            try {
                contents.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        this.checkState();
        this.receiver.addedFile(relativePath);
    }

    @Override
    public void addSymlink(String relativePath, String target, Map<String, byte[]> properties, long replacesRevision) {
        this.checkState();
        this.receiver.addedSymlink(relativePath);
    }

    @Override
    public void addAbsent(String relativePath, NodeKind kind, long replacesRevision) {
        this.checkState();
    }

    @Override
    public void alterDirectory(String relativePath, long revision, Iterable<String> children, Map<String, byte[]> properties) {
        this.checkState();
        this.receiver.modifiedDirectory(relativePath, children != null, StatusEditor.props_changed(properties), this.make_entry(properties));
    }

    @Override
    public void alterFile(String relativePath, long revision, Checksum checksum, InputStream contents, Map<String, byte[]> properties) {
        if (contents != null) {
            try {
                contents.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        this.checkState();
        this.receiver.modifiedFile(relativePath, checksum != null && contents != null, StatusEditor.props_changed(properties), this.make_entry(properties));
    }

    @Override
    public void alterSymlink(String relativePath, long revision, String target, Map<String, byte[]> properties) {
        this.checkState();
        this.receiver.modifiedSymlink(relativePath, target != null, StatusEditor.props_changed(properties), this.make_entry(properties));
    }

    @Override
    public void delete(String relativePath, long revision) {
        this.checkState();
        this.receiver.deleted(relativePath);
    }

    @Override
    public void copy(String sourceRelativePath, long sourceRevision, String destinationRelativePath, long replacesRevision) {
        this.checkState();
        throw new RuntimeException("Not implemented: StatusEditor.copy");
    }

    @Override
    public void move(String sourceRelativePath, long sourceRevision, String destinationRelativePath, long replacesRevision) {
        this.checkState();
        throw new RuntimeException("Not implemented: StatusEditor.move");
    }

    @Override
    public void complete() {
        this.abort();
    }

    @Override
    public void abort() {
        this.checkState();
        this.receiver = null;
    }

    private final RemoteStatus.Entry make_entry(Map<String, byte[]> properties) {
        byte[] raw_uuid = properties.get(entryprop_uuid);
        byte[] raw_author = properties.get(entryprop_author);
        byte[] raw_revision = properties.get(entryprop_revision);
        byte[] raw_timestamp = properties.get(entryprop_timestamp);
        long parsed_timestamp = -1L;
        if (raw_timestamp != null) {
            String isodate = new String(raw_timestamp, UTF8);
            int year = Integer.valueOf(isodate.substring(0, 4), 10);
            int month = Integer.valueOf(isodate.substring(5, 7), 10);
            int day = Integer.valueOf(isodate.substring(8, 10), 10);
            int hour = Integer.valueOf(isodate.substring(11, 13), 10);
            int minute = Integer.valueOf(isodate.substring(14, 16), 10);
            int second = Integer.valueOf(isodate.substring(17, 19), 10);
            int micro = Integer.valueOf(isodate.substring(20, 26), 10);
            this.entry_calendar.set(year, month, day, hour, minute, second);
            parsed_timestamp = (1000L * this.entry_calendar.getTimeInMillis() + (long)micro + 500L) / 1000L;
        }
        return new RemoteStatus.Entry(raw_uuid == null ? null : new String(raw_uuid, UTF8), raw_author == null ? null : new String(raw_author, UTF8), raw_revision == null ? -1L : Long.valueOf(new String(raw_revision, UTF8), 10), parsed_timestamp);
    }

    private static final boolean props_changed(Map<String, byte[]> properties) {
        if (properties != null) {
            for (String name : properties.keySet()) {
                if (name.startsWith(wcprop_prefix) || name.startsWith(entryprop_prefix)) continue;
                return true;
            }
        }
        return false;
    }
}

