/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.PrintWriter;
import oracle.aurora.util.Assertion;
import oracle.aurora.util.BTProbe;
import oracle.aurora.util.BTree;
import oracle.aurora.util.BTreeINode;
import oracle.aurora.util.BTreeNode;

class BTreeLNode
extends BTreeNode {
    BTreeLNode(BTree t, BTreeINode p) {
        super(t, p);
        this.slots = new Object[this.lnodeOrder()];
    }

    void printOn(PrintWriter out, boolean recurse, int level) {
        out.println();
        BTreeLNode.indentOn(out, level);
        out.print("Leaf: " + this.hashCode() + ", order: " + this.lnodeOrder() + " ");
        super.printOn(out, recurse, level);
        for (int i = 0; i < this.size; ++i) {
            this.printElementOn(out, i, level);
        }
        out.flush();
    }

    int order() {
        return this.lnodeOrder();
    }

    int totalSize() {
        return this.size;
    }

    int totalCapacity() {
        return this.lnodeOrder();
    }

    Object getElement(int idx) {
        return this.slots[idx];
    }

    void setElement(int idx, Object obj) {
        this.slots[idx] = obj;
    }

    boolean probe(Object obj, BTProbe probe) {
        probe.node = this;
        if (this.size == 0) {
            probe.index = 0;
            probe.comparison = -1;
            return false;
        }
        if (this.size < 9) {
            probe.index = 0;
            while (probe.index < this.size) {
                probe.comparison = this.tree.comparator.compare(obj, this.getElement(probe.index));
                if (probe.comparison < 0) {
                    return false;
                }
                if (probe.comparison == 0) {
                    return true;
                }
                ++probe.index;
            }
            probe.index = this.size - 1;
            return false;
        }
        probe.index = 0;
        probe.comparison = this.tree.comparator.compare(obj, this.getElement(probe.index));
        if (probe.comparison < 0) {
            int lower = 0;
            probe.index = this.size - 1;
            probe.comparison = this.tree.comparator.compare(obj, this.getElement(probe.index));
            if (probe.comparison < 0) {
                int upper = this.size - 1;
                while (true) {
                    if (upper - lower <= 1) {
                        probe.index = upper;
                        probe.comparison = -1;
                        break;
                    }
                    probe.index = lower + (upper - lower) / 2;
                    probe.comparison = this.tree.comparator.compare(obj, this.getElement(probe.index));
                    if (probe.comparison > 0) {
                        lower = probe.index;
                        continue;
                    }
                    if (probe.comparison == 0) break;
                    upper = probe.index;
                }
            }
        }
        if (probe.comparison == 0) {
            while (probe.index > 0 && this.tree.comparator.compare(obj, this.getElement(probe.index - 1)) == 0) {
                --probe.index;
            }
            return true;
        }
        return false;
    }

    boolean findNext(BTProbe probe) {
        if (BTree.oassert.on()) {
            Assertion.oassert(probe.index < this.size);
        }
        if (probe.index < this.size - 1) {
            probe.node = this;
            ++probe.index;
            return true;
        }
        probe.node = this;
        BTreeINode p = this.parent;
        while (p != null) {
            probe.index = p.indexOf(probe.node);
            probe.node = p;
            if (probe.index < p.size) {
                return true;
            }
            p = p.parent;
        }
        probe.node = null;
        return false;
    }

    boolean findPrev(BTProbe probe) {
        if (BTree.oassert.on()) {
            Assertion.oassert(probe.index < this.size);
        }
        probe.node = this;
        if (probe.index > 0) {
            --probe.index;
            return true;
        }
        BTreeINode p = this.parent;
        while (p != null) {
            probe.index = p.indexOf(probe.node);
            probe.node = p;
            if (probe.index > 0) {
                --probe.index;
                return true;
            }
            p = p.parent;
        }
        probe.node = null;
        return false;
    }

    BTreeLNode firstLeaf() {
        return this;
    }

    BTreeLNode lastLeaf() {
        return this;
    }

    Object insert(Object obj, BTProbe probe) {
        if (BTree.oassert.on()) {
            Assertion.oassert(probe.index <= this.size && (probe.comparison != 0 || probe.comparison == this.tree.comparator.compare(obj, this.getElement(probe.index))));
        }
        if (probe.comparison > 0) {
            ++probe.index;
        }
        this.insert(obj, probe.index);
        this.checkIfFull();
        return obj;
    }

    void removeElement(int index) {
        if (BTree.oassert.on()) {
            Assertion.oassert(index < this.size);
        }
        this.remove(index, 1);
    }

    void remove(int idx) {
        this.remove(idx, 1);
    }

    void remove(int idx, int count) {
        this._remove(idx, count);
        this.checkIfLow();
    }

    void _remove(int idx) {
        this._remove(idx, 1);
    }

    void _remove(int idx, int count) {
        int i;
        if (BTree.oassert.on()) {
            Assertion.oassert(idx >= 0 && idx < this.size);
        }
        for (i = idx + count; i < this.size; ++i) {
            this.slots[i - 1] = this.slots[i];
        }
        for (i = this.size - count; i < this.size; ++i) {
            this.slots[i] = null;
        }
        this.size = (short)(this.size - count);
    }

    void _insert(int idx, int count) {
        int i;
        for (i = this.size - 1; i >= idx; --i) {
            this.slots[i + count] = this.slots[i];
        }
        for (i = idx; i < idx + count; ++i) {
            this.slots[i] = null;
        }
        this.size = (short)(this.size + count);
    }

    void insert(Object obj, int idx) {
        this._insert(idx, 1);
        this.setElement(idx, obj);
    }

    void pushLeft(int toMove, BTreeNode l, int index) {
        if (BTree.oassert.on()) {
            Assertion.oassert(l.isLNode() && this.parent.getRightSubTree(index) == this && this.parent.getLeftSubTree(index) == l && toMove > 0 && toMove <= this.size && toMove + l.size < this.lnodeOrder());
        }
        BTreeLNode lsib = (BTreeLNode)l;
        short lss = lsib.size;
        lsib.size = (short)(lsib.size + toMove);
        lsib.setElement(lss, this.parent.getElement(index));
        for (int i = 0; i < toMove - 1; ++i) {
            lsib.setElement(lss + i + 1, this.getElement(i));
        }
        this.parent.setElement(index, this.getElement(toMove - 1));
        this._remove(0, toMove);
    }

    void pushRight(int toMove, BTreeNode r, int index) {
        if (BTree.oassert.on()) {
            Assertion.oassert(r.isLNode() && this.parent.getLeftSubTree(index) == this && this.parent.getRightSubTree(index) == r && toMove > 0 && toMove <= this.size && toMove + r.size < this.lnodeOrder());
        }
        BTreeLNode rsib = (BTreeLNode)r;
        rsib._insert(0, toMove);
        rsib.setElement(toMove - 1, this.parent.getElement(index));
        for (int i = 0; i < toMove - 1; ++i) {
            rsib.setElement(i, this.getElement(this.size - toMove + i + 1));
        }
        this.parent.setElement(index, this.getElement(this.size - toMove));
        this._remove(this.size - toMove, toMove);
    }

    void splitWithRight(BTreeNode r, int index) {
        if (BTree.oassert.on()) {
            Assertion.oassert(r.isLNode() && this.parent.getLeftSubTree(index) == this && this.parent.getRightSubTree(index) == r);
        }
        BTreeLNode rsib = (BTreeLNode)r;
        int nSize = (this.size + rsib.size + 2) / 3;
        int moveThis = Math.max(this.size - nSize, 1);
        int moveSib = Math.max(rsib.size - nSize, 1);
        BTreeLNode newNode = new BTreeLNode(this.tree, this.parent);
        this.parent._insert(index + 1, 1, true);
        this.parent.moveSubTree(newNode, index + 1);
        this.parent.setElement(index + 1, rsib.getElement(0));
        rsib._remove(0);
        if (moveSib > 1) {
            rsib.pushLeft(moveSib - 1, newNode, index + 1);
        }
        this.pushRight(moveThis, newNode, index);
        this.parent.checkIfFull();
    }

    void split() {
        if (BTree.oassert.on()) {
            Assertion.oassert(this.isFull() && this.parent.size == 0 && this.parent.indexOf(this) == 0);
        }
        BTreeLNode newNode = new BTreeLNode(this.tree, this.parent);
        this.parent.size = (short)(this.parent.size + 1);
        this.parent.setElement(0, this.getElement(this.size - 1));
        this.parent.moveSubTree(newNode, 1);
        this._remove(this.size - 1);
        this.balanceWithRight(newNode, 0);
    }

    void mergeWithRight(BTreeNode r, int index) {
        if (BTree.oassert.on()) {
            Assertion.oassert(r.isLNode() && this.parent.getLeftSubTree(index) == this && this.parent.getRightSubTree(index) == r && this.size + r.size + 1 < this.lnodeOrder());
        }
        BTreeLNode rsib = (BTreeLNode)r;
        if (this.size >= rsib.size) {
            if (rsib.size > 0) {
                rsib.pushLeft(rsib.size, this, index);
            }
            this.insert(this.parent.getElement(index), this.size);
            this.parent._remove(index, 1, false);
            this.parent.checkIfLow();
        } else {
            if (this.size > 0) {
                this.pushRight(this.size, rsib, index);
            }
            rsib.insert(this.parent.getElement(index), 0);
            this.parent._remove(index, 1, true);
            this.parent.checkIfLow();
        }
    }
}

