/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.aurora.server.tools.loadjava.LoadJavaState;
import oracle.aurora.server.tools.loadjava.MkMsg;
import oracle.aurora.server.tools.loadjava.Options;
import oracle.aurora.server.tools.loadjava.ToolsException;
import oracle.aurora.util.classfile.Dig;
import oracle.aurora.util.classfile.Raw;
import oracle.aurora.util.classfile.Type;
import oracle.aurora.util.msg.Msg;
import oracle.aurora.util.tools.ToolException;

class Publish {
    private LoadJavaState state;
    private Msg mkMsg = MkMsg.mkMsg;
    int pubMain;
    Hashtable packages;

    Publish(LoadJavaState state) {
        this.state = state;
        this.pubMain = 3;
        if (state.getOpts().getString("-pubmain") != null) {
            this.pubMain = this.pubMainOf(state.getOpts());
        }
    }

    int pubMainOf(Options opts) {
        int n = -1;
        String nString = opts.getString("-pubmain");
        if (nString != null) {
            try {
                n = Integer.parseInt(nString);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return n;
    }

    void add(InputStream in, Options opts) throws ToolException, IOException {
        Dig dig = new Dig(new Raw.Class(in));
        this.add(dig.getClazz(), this.state.getOpts());
    }

    void add(Dig.Class clazz, Options opts) {
        opts.setOptionFile(this.state.getOptionFile());
        Options addopts = opts.getOptionsFor(clazz.getName());
        if (addopts.getString("-publish") != null && clazz.isPublic()) {
            Package pkg = this.addPackage(addopts.getString("-publish"), addopts);
            Dig.Methods methods = clazz.getMethods();
            for (int x = 0; x < methods.count(); ++x) {
                Dig.Member method = methods.get(x);
                pkg.addMethod(method, addopts);
            }
        }
    }

    Package addPackage(String name, Options opts) {
        String tName = this.transform(name, opts);
        Package pkg = null;
        if (this.packages == null) {
            this.packages = new Hashtable();
        } else {
            pkg = (Package)this.packages.get(tName);
        }
        if (pkg == null) {
            pkg = new Package(tName, opts);
            this.packages.put(name, pkg);
        }
        return pkg;
    }

    String transform(String name, Options opts) {
        boolean needsQuotes = false;
        if (opts.getBoolean("casesensitivepub")) {
            boolean hasLower = false;
            for (int x = 0; !hasLower && x < name.length(); ++x) {
                hasLower = Character.isLowerCase(name.charAt(x));
            }
            needsQuotes = hasLower;
        } else {
            StringBuffer newName = new StringBuffer(name.length());
            boolean prevIsLower = false;
            for (int x = 0; x < name.length(); ++x) {
                char c = name.charAt(x);
                boolean isUpper = Character.isUpperCase(c);
                if (prevIsLower && isUpper) {
                    newName.append('_');
                }
                newName.append(Character.toUpperCase(c));
                prevIsLower = Character.isLowerCase(c);
            }
            name = newName.toString();
        }
        if (name.length() > 31) {
            name = name.substring(0, 31);
        }
        if (needsQuotes) {
            name = '\"' + name + '\"';
        }
        return name;
    }

    boolean isString(Type t) {
        String stringClassName = "java/lang/String";
        String name = t.getClassName();
        return name != null && name.equals(stringClassName);
    }

    void publishPackages() {
        if (this.packages != null) {
            Enumeration pkgs = this.packages.elements();
            while (pkgs.hasMoreElements()) {
                Package pkg = (Package)pkgs.nextElement();
                pkg.publish();
            }
        }
    }

    void dropPackages() {
        if (this.packages != null) {
            Enumeration pkgs = this.packages.elements();
            while (pkgs.hasMoreElements()) {
                Package pkg = (Package)pkgs.nextElement();
                pkg.drop();
            }
        }
    }

    public static void main(String[] argv) throws ToolsException, IOException, ToolException {
        LoadJavaState state = new LoadJavaState();
        Options.Args args = new Options.Args(argv);
        state.parseArgs(args);
        String[] files = args.unused();
        Publish publish = state.getPublish();
        for (int xFile = 0; xFile < files.length; ++xFile) {
            FileInputStream in = new FileInputStream(files[xFile]);
            Dig dig = new Dig(new Raw.Class(in));
            publish.add(dig.getClazz(), state.getOpts());
        }
        Enumeration pkgEnum = publish.packages.elements();
        while (pkgEnum.hasMoreElements()) {
            Package pkg = (Package)pkgEnum.nextElement();
            System.out.println(pkg);
            System.out.println(pkg.ddl());
            pkg.publish();
        }
    }

    void err(String msg) {
        this.state.err(msg);
    }

    void msg(String msg) {
        this.state.msg(msg);
    }

    class Method {
        String sqlSignature;
        String javaSignature;

        Method(String sqlSignature, String javaSignature) {
            this.javaSignature = javaSignature;
            this.sqlSignature = sqlSignature;
        }

        public String toString() {
            return this.sqlSignature + " AS LANGUAGE JAVA NAME '" + this.javaSignature + "'";
        }
    }

    class Package {
        boolean definers;
        String name;
        Vector methods;

        Package(String name, Options opts) {
            this.name = name;
            this.methods = new Vector();
            this.definers = opts.getBoolean("-definers");
        }

        void addMethod(Dig.Member method, Options opts) {
            if (method.isStatic() && method.isPublic()) {
                if (this.isMappableMethod(method.getType())) {
                    this.addMappableMethod(method, opts);
                    ++((Publish)Publish.this).state.ld_published;
                } else if (this.isMainMethod(method.getType())) {
                    this.addMainMethod(method, opts);
                    ++((Publish)Publish.this).state.ld_published;
                }
            }
        }

        boolean isMappableMethod(Type t) {
            boolean mappable = true;
            Type[] args = t.params();
            for (int xArg = 0; mappable && xArg < args.length; ++xArg) {
                mappable = this.isMappableValue(args[xArg]);
            }
            Type r = t.returnType();
            if (mappable) {
                mappable = r.isPrimitive('V') || this.isMappableValue(r);
            }
            return mappable;
        }

        boolean isMappableValue(Type type) {
            boolean mappable;
            switch (type.getKind()) {
                case 'B': {
                    mappable = true;
                    break;
                }
                case 'C': {
                    mappable = true;
                    break;
                }
                case 'D': {
                    mappable = true;
                    break;
                }
                case 'F': {
                    mappable = true;
                    break;
                }
                case 'I': {
                    mappable = true;
                    break;
                }
                case 'J': {
                    mappable = true;
                    break;
                }
                case 'S': {
                    mappable = true;
                    break;
                }
                case 'Z': {
                    mappable = true;
                    break;
                }
                case 'V': {
                    mappable = false;
                    break;
                }
                case 'L': {
                    mappable = Publish.this.isString(type);
                    break;
                }
                case '(': {
                    mappable = false;
                    break;
                }
                case '[': {
                    mappable = false;
                    break;
                }
                default: {
                    mappable = false;
                }
            }
            return mappable;
        }

        boolean isMainMethod(Type methodType) {
            Type rType = methodType.returnType();
            Type[] args = methodType.params();
            boolean oneStringArg = args.length == 1 && args[0].isArray() && args[0].dim() == 1 && Publish.this.isString(args[0].elem());
            boolean returnOk = rType.isPrimitive('V') || this.isMappableValue(rType);
            return oneStringArg && returnOk;
        }

        void addMappableMethod(Dig.Member method, Options opts) {
            Type type = method.getType();
            String name = method.getName();
            String sqlName = Publish.this.transform(name, opts);
            String className = method.containingClass().getName();
            String javaName = className + "." + name;
            String[] sqlArgs = this.toSql(type.params());
            this.addMethod(sqlName, sqlArgs, this.toSql(type.returnType()), javaName, type.params(), type.returnType());
        }

        void addMethod(String sqlName, String[] sqlArgs, String sqlReturn, String javaName, Type[] javaArgs, Type javaReturn) {
            StringBuffer sqlDecl = new StringBuffer();
            if (sqlReturn == null) {
                sqlDecl.append("PROCEDURE ");
            } else {
                sqlDecl.append("FUNCTION ");
            }
            sqlDecl.append(sqlName);
            if (sqlArgs.length > 0) {
                sqlDecl.append('(');
                for (int xArg = 0; xArg < sqlArgs.length; ++xArg) {
                    sqlDecl.append("arg").append(Integer.toString(xArg));
                    sqlDecl.append(' ').append(sqlArgs[xArg]);
                    if (xArg + 1 >= sqlArgs.length) continue;
                    sqlDecl.append(',');
                }
                sqlDecl.append(')');
            }
            if (sqlReturn != null) {
                sqlDecl.append(" RETURN ").append(sqlReturn);
            }
            StringBuffer javaDecl = new StringBuffer();
            javaDecl.append(javaName).append('(');
            for (int xArg = 0; xArg < javaArgs.length; ++xArg) {
                javaDecl.append(javaArgs[xArg].declaration());
                if (xArg + 1 >= javaArgs.length) continue;
                javaDecl.append(',');
            }
            javaDecl.append(')');
            if (!javaReturn.isPrimitive('V')) {
                javaDecl.append(" return ").append(javaReturn.declaration());
            }
            String sDecl = sqlDecl.toString();
            String jDecl = javaDecl.toString();
            Enumeration priors = this.methods.elements();
            boolean ok = true;
            while (priors.hasMoreElements() && ok) {
                Method prior = (Method)priors.nextElement();
                if (!prior.sqlSignature.equals(sDecl)) continue;
                Publish.this.mkMsg.m("duplicate declarations of {0} as {1} and {2} ", sDecl, prior.javaSignature, jDecl);
            }
            if (ok) {
                this.methods.addElement(new Method(sDecl, jDecl));
            }
        }

        void addMainMethod(Dig.Member method, Options opts) {
            Type type = method.getType();
            String name = method.getName();
            String sqlName = Publish.this.transform(name, opts);
            String className = method.containingClass().getName();
            String javaName = className + "." + name;
            String sqlReturn = this.toSql(type.returnType());
            for (int xArgs = 0; xArgs <= Publish.this.pubMain; ++xArgs) {
                String[] sqlArgs = new String[xArgs];
                for (int xSql = 0; xSql < xArgs; ++xSql) {
                    sqlArgs[xSql] = "VARCHAR";
                }
                this.addMethod(sqlName, sqlArgs, sqlReturn, javaName, type.params(), type.returnType());
            }
        }

        String toSql(Type type) {
            String mapped;
            switch (type.getKind()) {
                case 'B': {
                    mapped = "NUMBER";
                    break;
                }
                case 'C': {
                    mapped = "VARCHAR";
                    break;
                }
                case 'D': {
                    mapped = "NUMBER";
                    break;
                }
                case 'F': {
                    mapped = "NUMBER";
                    break;
                }
                case 'I': {
                    mapped = "NUMBER";
                    break;
                }
                case 'J': {
                    mapped = "NUMBER";
                    break;
                }
                case 'S': {
                    mapped = "NUMBER";
                    break;
                }
                case 'Z': {
                    mapped = "NUMBER";
                    break;
                }
                case 'V': {
                    mapped = null;
                    break;
                }
                case 'L': {
                    mapped = Publish.this.isString(type) ? "VARCHAR" : null;
                    break;
                }
                case '(': {
                    mapped = null;
                    break;
                }
                case '[': {
                    mapped = null;
                    break;
                }
                default: {
                    mapped = null;
                }
            }
            return mapped;
        }

        String[] toSql(Type[] types) {
            String[] sql = new String[types == null ? 0 : types.length];
            for (int x = 0; x < sql.length; ++x) {
                sql[x] = this.toSql(types[x]);
            }
            return sql;
        }

        void publish() {
            Publish.this.msg(Publish.this.mkMsg.m("publishing: wrapper {0}", this.toString()));
            Publish.this.state.getJdbc().executeDDL(this.ddl(), "creating SQL wrapper " + this);
        }

        void drop() {
            Publish.this.msg(Publish.this.mkMsg.m("dropping  : wrapper {0}", this.toString()));
            Publish.this.state.getJdbc().executeDDL("DROP PACKAGE " + this.name, "dropping SQL wrapper " + this);
        }

        String ddl() {
            StringBuffer sql = new StringBuffer();
            sql.append("CREATE OR REPLACE PACKAGE ");
            sql.append(this.name);
            sql.append(" AUTHID CURRENT_USER AS\n");
            Enumeration eMethods = this.methods.elements();
            while (eMethods.hasMoreElements()) {
                Method m = (Method)eMethods.nextElement();
                sql.append("    ").append(m.toString()).append(";\n");
            }
            sql.append("END;");
            return sql.toString();
        }

        public String toString() {
            return "package " + this.name;
        }
    }
}

