/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import oracle.aurora.server.tools.loadjava.LoadJavaOptions;
import oracle.aurora.server.tools.loadjava.LoadJavaState;
import oracle.aurora.server.tools.loadjava.Options;
import oracle.aurora.util.IOCopy;

public class OptionFile {
    private LoadJavaState state;
    private Options template;
    private IOCopy ioCopy = new IOCopy();
    private StreamTokenizer tokenizer;
    private Line[] lines;

    public OptionFile(LoadJavaState state) {
        this.state = state;
        this.template = state.getOpts().clone(null);
        this.template.clear();
        this.lines = null;
    }

    public OptionFile(LoadJavaState state, InputStream in) throws IOException {
        this(state, new IOCopy().toReader(in));
    }

    public OptionFile(LoadJavaState state, Reader in) throws IOException {
        this(state);
        if (in != null) {
            this.read(in);
        }
    }

    public OptionFile(LoadJavaState state, ResultSet in) throws SQLException {
        this(state);
        if (in != null) {
            this.read(in);
        }
    }

    public Options getOptionsFor(String className, Options opts) {
        for (int x = 0; x < this.lines.length; ++x) {
            Line line = this.lines[x];
            if (!line.match(className)) continue;
            opts = line.modify(className, opts);
        }
        return opts;
    }

    StreamTokenizer mkTokenizer(Reader in) {
        StreamTokenizer tokenizer = new StreamTokenizer(in);
        tokenizer.resetSyntax();
        tokenizer.wordChars(0, Integer.MAX_VALUE);
        tokenizer.eolIsSignificant(true);
        tokenizer.slashSlashComments(true);
        tokenizer.quoteChar(34);
        tokenizer.whitespaceChars(32, 32);
        tokenizer.whitespaceChars(13, 13);
        tokenizer.whitespaceChars(10, 10);
        tokenizer.whitespaceChars(9, 9);
        tokenizer.lowerCaseMode(false);
        tokenizer.commentChar(35);
        return tokenizer;
    }

    void read(Reader in) throws IOException {
        StreamTokenizer t = this.mkTokenizer(in);
        int count = 0;
        Vector<Line> vLines = new Vector<Line>();
        while (t.ttype != -1) {
            ++count;
            int first = t.nextToken();
            if (first != -3) continue;
            String pattern = t.sval;
            Vector<String> vLine = new Vector<String>();
            int w = t.nextToken();
            while (w == -3) {
                vLine.addElement(t.sval);
                w = t.nextToken();
            }
            Options lineOpts = this.template.clone(null);
            Object[] args = new String[vLine.size()];
            vLine.copyInto(args);
            String[] unparsed = lineOpts.parseArgs((String[])args);
            if (unparsed.length > 0) {
                for (int x = 0; x < unparsed.length; ++x) {
                    this.err("unrecognized option(" + unparsed[x] + ") on line " + count + " of " + in);
                }
            }
            vLines.addElement(new Line(pattern, lineOpts));
        }
        this.lines = new Line[vLines.size()];
        for (int x = 0; x < this.lines.length; ++x) {
            this.lines[x] = (Line)vLines.elementAt(x);
        }
        this.sort(this.lines);
    }

    void read(ResultSet in) throws SQLException {
        Hashtable<String, Options> optionMap = new Hashtable<String, Options>();
        while (in.next()) {
            String[] unrec;
            String pattern = in.getString(1);
            String option = in.getString(2);
            String value = in.getString(3);
            Options pOpts = (Options)optionMap.get(pattern);
            if (pOpts == null) {
                pOpts = new Options();
                optionMap.put(pattern, pOpts);
            }
            if ((unrec = value == null ? pOpts.parseArgs(new String[]{option}) : pOpts.parseArgs(new String[]{option, value})) == null || unrec.length <= 0) continue;
            this.err("unrecognize option " + option + " in table");
        }
        Iterator keys = optionMap.keySet().iterator();
        this.lines = new Line[optionMap.size()];
        int x = 0;
        while (keys.hasNext()) {
            String pattern = (String)keys.next();
            this.lines[x] = new Line(pattern, (Options)optionMap.get(pattern));
            ++x;
        }
        this.sort(this.lines);
    }

    void sort(Line[] lines) {
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                Line line1 = (Line)o1;
                Line line2 = (Line)o2;
                if (line1.star && !line2.star) {
                    return -1;
                }
                if (line2.star && !line1.star) {
                    return 1;
                }
                if (line1.pattern.length() < line2.pattern.length()) {
                    return -1;
                }
                if (line1.pattern.length() > line2.pattern.length()) {
                    return 1;
                }
                return 0;
            }
        };
        Arrays.sort(lines, c);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int x = 0; x < this.lines.length; ++x) {
            buf.append(this.lines[x]).append(' ');
        }
        return buf.toString();
    }

    public static void main(String[] argv) throws IOException {
        String fileName = argv[0];
        String className = argv[1];
        FileInputStream in = new FileInputStream(fileName);
        LoadJavaOptions ljOpts = new LoadJavaOptions();
        ljOpts.set("-synonym", Boolean.FALSE);
        LoadJavaState state = new LoadJavaState(ljOpts);
        OptionFile o = new OptionFile(state, in);
        in.close();
        System.out.println("sorted lines of OptionFile");
        for (int x = 0; x < o.lines.length; ++x) {
            System.out.println("    " + o.lines[x]);
        }
        System.out.println("lookup for " + className + ": " + o.getOptionsFor(className, ljOpts));
    }

    void err(String msg) {
        this.state.err(msg);
    }

    static class Line {
        String pattern;
        Options lineOpts;
        boolean star;

        Line(String pattern, Options lineOpts) {
            this.pattern = pattern;
            this.lineOpts = lineOpts;
            this.star = pattern.endsWith("*");
            if (this.star) {
                this.pattern = pattern.substring(0, pattern.length() - 1);
            }
        }

        boolean match(String name) {
            return this.star ? name.startsWith(this.pattern) : name.equals(this.pattern);
        }

        Options modify(String name, Options opts) {
            Options result = opts;
            if (this.match(name)) {
                result = opts == null ? this.lineOpts : this.lineOpts.clone(result);
            }
            return result;
        }

        public String toString() {
            return this.pattern + (this.star ? "*" : "") + " -> " + this.lineOpts;
        }
    }
}

