/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import oracle.aurora.server.tools.loadjava.ClassifyFiles;
import oracle.aurora.server.tools.loadjava.DatabaseOptions;
import oracle.aurora.server.tools.loadjava.GenMissing;
import oracle.aurora.server.tools.loadjava.JdbcOperations;
import oracle.aurora.server.tools.loadjava.LoadJavaConstants;
import oracle.aurora.server.tools.loadjava.LoadJavaLog;
import oracle.aurora.server.tools.loadjava.LoadJavaOptions;
import oracle.aurora.server.tools.loadjava.LoadJavaState;
import oracle.aurora.server.tools.loadjava.MkMsg;
import oracle.aurora.server.tools.loadjava.OptionFile;
import oracle.aurora.server.tools.loadjava.Options;
import oracle.aurora.server.tools.loadjava.Publish;
import oracle.aurora.server.tools.loadjava.SchemaObject;
import oracle.aurora.server.tools.loadjava.ToolsError;
import oracle.aurora.server.tools.loadjava.ToolsException;
import oracle.aurora.util.IOCopy;
import oracle.aurora.util.msg.Msg;

public class LoadJava
implements LoadJavaConstants {
    private Msg mkMsg = MkMsg.mkMsg;
    private ClassifyFiles classifier;
    static final String optionsEntryName = "META-INF/loadjava-options";
    private IOCopy ioCopy = new IOCopy();
    private LoadJavaState state;
    private int usageErrorCount;
    private Vector schemaObjects;
    private Vector deferredFiles;
    private Vector serObjects;
    private SchemaObject currentJar;

    LoadJava(LoadJavaOptions opts, DatabaseOptions database, LoadJavaLog log) throws ToolsException {
        this.state = new LoadJavaState(opts, database, log);
        this.initialize();
    }

    public LoadJava() {
        this.state = new LoadJavaState();
        try {
            this.initialize();
        }
        catch (ToolsException toolsException) {
            // empty catch block
        }
    }

    void checkUserExists(String schema) throws ToolsException {
        if (schema != null && !this.state.getJdbc().userExists(schema)) {
            String e = this.mkMsg.m("schema {0} does not exist ", schema);
            this.err(e);
            throw new ToolsException(e);
        }
    }

    void initialize() throws ToolsException {
        LoadJavaOptions ljOpts = this.getOpts();
        this.schemaObjects = new Vector();
        this.serObjects = new Vector();
        this.usageErrorCount = 0;
        this.classifier = null;
        if (ljOpts.getString("-btl") != null) {
            this.state.getJdbc().startBTL(ljOpts.getString("-btl"));
        }
        this.checkUserExists(ljOpts.getLoadSchema());
        this.checkUserExists(ljOpts.getTableSchema());
    }

    void reset() {
        if (this.state != null) {
            if (this.getOpts().getString("-btl") != null) {
                this.state.getJdbc().terminateBTL(this.getOpts().getString("-btl"));
            }
            this.state.resetStmts();
        }
    }

    private void print(String what, String[] argv) {
        System.out.print(what + ":");
        for (int x = 0; x < argv.length; ++x) {
            System.out.print(" " + argv[x]);
        }
        System.out.println();
    }

    public String[] parseArgs(String[] argv) throws ToolsException {
        Options.Args args = new Options.Args(argv);
        this.getState().parseArgs(args);
        if (this.getState().getDbs().getDriver().equals("thin")) {
            this.getOpts().set("-noserverside", "true");
        }
        this.initialize();
        if (!this.getOpts().getBoolean("-compat817") && this.getState().getLog().getOpts().getVerbose()) {
            StringBuffer m = new StringBuffer("arguments: ");
            for (int xArg = 0; xArg < args.length(); ++xArg) {
                String astr = args.get(xArg);
                if (astr.startsWith("-u")) {
                    m.append("'").append(astr).append("' ");
                    astr = args.get(++xArg);
                    astr = astr.replaceFirst("([a-zA-Z0-9_]*)/([a-zA-Z0-9_]*)(@)?", "$1/***$3");
                    m.append("'").append(astr).append("' ");
                    continue;
                }
                if (astr.equals("-P") || astr.equals("-password")) {
                    m.append("'").append(astr).append("' ");
                    ++xArg;
                    m.append("'").append("***").append("' ");
                    continue;
                }
                m.append("'").append(astr).append("' ");
            }
            if (this.getOpts().getBoolean("-nativecompile")) {
                this.getOpts().set("-resolve", "true");
            }
            this.msg(m.toString());
        }
        return args.unused();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void command(String[] argv) throws ToolsException {
        block13: {
            try {
                String[] files = this.parseArgs(argv);
                for (int xFile = 0; xFile < files.length; ++xFile) {
                    if (files[xFile].length() == 0) {
                        this.usageErr(this.mkMsg.m("an empty argument was supplied"));
                        continue;
                    }
                    if (files[xFile].charAt(0) != '-') continue;
                    this.usageErr(this.mkMsg.m("unrecognized or badly formed option {0}", files[xFile]));
                }
                if (this.getOpts().getBoolean("-help")) {
                    this.err("loadjava: " + LoadJavaOptions.helpMessage());
                    break block13;
                }
                if (files.length == 0 && !this.getOpts().getBoolean("-nousage")) {
                    this.usageMessage();
                    break block13;
                }
                if (this.usageErrorCount > 0) {
                    this.usageMessage();
                    break block13;
                }
                try {
                    this.addFiles(files);
                    this.getOpts().setOptionFile(this.getState().getOptionFile());
                    this.process();
                    if (this.getState().getLog().getOpts().getVerbose()) {
                        this.getState().printStats();
                    }
                }
                catch (ToolsError ex) {
                    throw new ToolsException(ex.getMessage(), ex);
                }
                catch (SchemaObject.SchemaObjectError ex) {
                    throw new ToolsException(ex.getMessage(), ex);
                }
            }
            finally {
                this.reset();
                if (this.getOpts().getBoolean("-install")) {
                    this.getState().getJdbc().closeSysObjStmt();
                }
            }
        }
    }

    LoadJavaState getState() {
        return this.state;
    }

    public LoadJavaOptions getOpts() {
        return (LoadJavaOptions)this.getState().getOpts();
    }

    public Options getGenericOpts() {
        return this.getOpts();
    }

    ClassifyFiles getClassifier() {
        if (this.classifier == null) {
            this.classifier = new ClassifyFiles(this.getOpts());
        }
        return this.classifier;
    }

    public void set(String option) {
        this.set(option, Boolean.TRUE);
    }

    public void set(String option, Object value) {
        this.getState().set(option, value);
    }

    public void add(InputStream istr, String name) {
        this.add(istr, name, this.getOpts());
    }

    public void add(InputStream istr, String name, LoadJavaOptions opts) {
        int type = this.getClassifier().typeFromName(name);
        this.add(type, istr, name, opts);
    }

    public void add(int type, InputStream istr, String name, LoadJavaOptions opts) {
        this.checkCancelled();
        try {
            istr = this.ioCopy.toBuffered(istr);
            String sName = this.getClassifier().transformName(name);
            switch (type) {
                case 1002: {
                    this.addJar(istr, sName, opts);
                    break;
                }
                case 29: {
                    this.addClass(istr, sName, opts);
                    break;
                }
                case 28: {
                    this.addSource(istr, sName, opts);
                    break;
                }
                case 1001: {
                    this.addObject(1001, istr, sName, opts);
                    break;
                }
                case 1003: {
                    this.addSqljSer(istr, sName, opts);
                    break;
                }
                case 30: {
                    if (this.getClassifier().isSqljProfile(name)) {
                        this.addSqljSer(istr, sName, opts);
                        break;
                    }
                    this.addObject(30, istr, sName, opts);
                    break;
                }
                default: {
                    ToolsException ex = new ToolsException("internal error");
                    this.addError(ex, "call to add(int, InputStream, String, LoadJavaOptions)", "type is " + type + " which is unknown)");
                    break;
                }
            }
        }
        catch (SchemaObject.NameError namex) {
            if (namex.ex != null) {
                this.err(namex.ex, this.mkMsg.m("determining classes contained in {0}", name));
            } else {
                this.err(this.mkMsg.m("The bytes of {0} appear to be badly formated.It was not possible to determine the name of the class", name));
            }
            this.add(SchemaObject.mkError(this.getState(), this.getOpts(), name, "creation"));
        }
        catch (SchemaObject.SchemaObjectError ex) {
            this.err(ex, this.mkMsg.m("creating {0} from {1}", SchemaObject.typeToString(type), name));
            this.add(SchemaObject.mkError(this.getState(), this.getOpts(), name, "creation"));
        }
    }

    public void add(InputStream istr, String name, String encoding) {
        LoadJavaOptions opts = new LoadJavaOptions(this.getOpts());
        opts.set("-encoding", encoding);
        this.add(istr, name, opts);
    }

    SchemaObject addObject(int type, InputStream istr, String name, LoadJavaOptions opts) {
        return this.add(SchemaObject.mk(type, this.getState(), this.getOpts(), istr, name));
    }

    void measureMemory(String when) {
        Runtime r = Runtime.getRuntime();
        r.gc();
        r.gc();
        this.msg(when + ": memory contains " + (r.totalMemory() - r.freeMemory()) + " bytes");
    }

    SchemaObject add(SchemaObject sObject) {
        if (this.currentJar != null) {
            this.currentJar.noteContainedObject(sObject);
        }
        if (!sObject.getOpts().getBoolean("-noaction")) {
            try {
                sObject.process1();
            }
            catch (RuntimeException rex) {
                this.err(rex, this.mkMsg.m("processing {0}", sObject.toString()));
            }
            this.schemaObjects.addElement(sObject);
        }
        sObject.resetBytes();
        return sObject;
    }

    SchemaObject addSqljSer(InputStream istr, String name, LoadJavaOptions opts) {
        try {
            byte[] bytes = this.ioCopy.toBytes(istr);
            InputStream byteIn = this.ioCopy.toInputStream(bytes, name);
            SchemaObject ser = SchemaObject.mk(30, this.getState(), opts, byteIn, name);
            this.serObjects.addElement(ser);
            return ser;
        }
        catch (IOException ioex) {
            return this.addError(ioex, "reading", name);
        }
    }

    SchemaObject addSource(InputStream istr, String name, LoadJavaOptions opts) {
        SchemaObject sObj = SchemaObject.mk(28, this.getState(), opts, istr, name);
        if (this.getClassifier().isDeployName(sObj.getName())) {
            sObj.set("-invoke");
        }
        this.add(sObj);
        return sObj;
    }

    SchemaObject addClass(InputStream istr, String name, LoadJavaOptions opts) {
        SchemaObject sObj = SchemaObject.mk(29, this.getState(), opts, istr, name);
        if (this.getClassifier().isDeployName(sObj.getName())) {
            sObj.set("-invoke");
        }
        return this.add(sObj);
    }

    void addFileName(String name) {
        if (this.deferredFiles == null) {
            this.deferredFiles = new Vector();
        }
        this.deferredFiles.addElement(name);
    }

    void processDeferredFiles() {
        if (this.deferredFiles != null) {
            Enumeration fileNames = this.deferredFiles.elements();
            while (fileNames.hasMoreElements()) {
                String name = (String)fileNames.nextElement();
                if (this.getClassifier().isURL(name)) {
                    this.add(name);
                    continue;
                }
                File file = this.getClassifier().mkFile(name);
                this.add(file);
            }
            this.deferredFiles = null;
        }
    }

    void addFiles(String[] names) {
        for (int xFile = 0; xFile < names.length; ++xFile) {
            this.addFileName(names[xFile]);
        }
    }

    SchemaObject addError(Exception ex, String when, String what) {
        this.err(ex, when + ": " + what);
        SchemaObject eObject = SchemaObject.mkError(this.getState(), this.getOpts(), what, "opening file");
        return this.add(eObject);
    }

    void add(String url) {
        InputStream in = null;
        URL u = null;
        Proxy proxy = null;
        URLConnection uc = null;
        try {
            u = new URL(url);
            if (this.getOpts().getBoolean("-proxy")) {
                String spec = this.getOpts().getString("-proxy");
                int index = spec.indexOf(58);
                if (index == -1) {
                    throw new IllegalArgumentException("Proxy address incorrectly  specified " + spec);
                }
                String host = spec.substring(0, index);
                int port = Integer.parseInt(spec.substring(index + 1));
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
                uc = u.openConnection(proxy);
            } else {
                uc = u.openConnection();
            }
            uc.setConnectTimeout(3000);
            in = uc.getInputStream();
            if (uc.getContentLength() == 0) {
                this.warn(url + " is empty");
            } else {
                this.add(in, u.getPath());
            }
        }
        catch (MalformedURLException mue) {
            this.addError(mue, "malformed url", u.toString());
        }
        catch (UnknownHostException uhe) {
            this.addError(uhe, "host not found for url", u.toString());
        }
        catch (IOException ex) {
            this.addError(ex, "opening url", u.toString());
        }
        catch (SecurityException sex) {
            this.err(sex, this.mkMsg.m("opening url {0}", u.toString()));
            if (sex instanceof AccessControlException) {
                throw new ToolsError(u.toString() + " access permissions failure.");
            }
            throw new ToolsError(this.mkMsg.m("opening url {0}", u.toString()));
        }
    }

    void add(File file) {
        if (file.length() == 0L && file.exists()) {
            this.warn(file.getPath() + " is empty");
        } else {
            try {
                FileInputStream in = new FileInputStream(file);
                this.add(in, file.getPath());
            }
            catch (IOException ex) {
                this.addError(ex, "opening file", file.getPath());
            }
            catch (SecurityException sex) {
                this.err(sex, this.mkMsg.m("opening file {0}", file.getPath()));
                if (sex instanceof AccessControlException) {
                    throw new ToolsError(file.getPath() + " access permissions failure.");
                }
                throw new ToolsError(this.mkMsg.m("opening file {0}", file.getPath()));
            }
        }
    }

    void setOptionFileInOpts(LoadJavaOptions opts, InputStream in) throws IOException {
        OptionFile newOptionFile = new OptionFile(this.getState(), in);
        opts.setOptionFile(newOptionFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addJar(InputStream istr, String name, LoadJavaOptions opts) {
        ZipInputStream jar = new ZipInputStream(istr);
        ClassifyFiles oldClassifier = this.classifier;
        SchemaObject oldCurrentJar = this.currentJar;
        if (!this.getOpts().getBoolean("-recursivejars")) {
            LoadJavaOptions jarOpts = new LoadJavaOptions(this.getOpts());
            jarOpts.set("-jarasresource");
            this.classifier = new ClassifyFiles(jarOpts);
        }
        try {
            opts = new LoadJavaOptions(opts);
            int count = 0;
            if (opts.getBoolean("-jarsasdbobjects")) {
                SchemaObject newCurrentJar = SchemaObject.mk(1002, this.getState(), opts, istr, name);
                newCurrentJar.setPrepend(this.getOpts().getBoolean("-prependjarnames"));
                newCurrentJar.setNested(this.currentJar != null);
                this.add(newCurrentJar);
                this.currentJar = newCurrentJar;
                jar = new ZipInputStream(this.currentJar.getRepeatableInputStream());
            }
            ZipEntry currentEntry = this.getNextEntry(jar);
            while (currentEntry != null) {
                if (!currentEntry.isDirectory()) {
                    if (currentEntry.getName().equals(optionsEntryName)) {
                        this.setOptionFileInOpts(opts, jar);
                        if (count > 0) {
                            this.warn("Processed META-INF/loadjava-options in " + name + " after some entries had already been processed." + " Some options may not be effective ");
                        }
                    } else {
                        ++count;
                        String entryName = currentEntry.getName();
                        this.add((InputStream)jar, entryName, opts);
                    }
                }
                jar.closeEntry();
                currentEntry = this.getNextEntry(jar);
            }
            if (count == 0) {
                this.warn("JarFile " + name + " has no entries");
            }
        }
        catch (IOException ioex) {
            this.err(ioex, this.mkMsg.m("reading {0}", name));
        }
        finally {
            this.classifier = oldClassifier;
            if (this.currentJar != null) {
                this.currentJar.doneLoading();
            }
            this.currentJar = oldCurrentJar;
            if (this.currentJar != null) {
                this.currentJar.resumeLoading();
            }
        }
    }

    private ZipEntry getNextEntry(ZipInputStream jar) throws IOException, ZipException {
        ZipEntry entry;
        try {
            entry = jar.getNextEntry();
        }
        catch (EOFException eof) {
            entry = null;
        }
        return entry;
    }

    void createMissingClasses() {
        LoadJavaOptions myOpts = new LoadJavaOptions(this.getOpts());
        myOpts.set("-genmissing", Boolean.FALSE);
        myOpts.unset("-genmissingjar");
        myOpts.set("-jarasresource", Boolean.FALSE);
        if (this.getOpts().getString("-genmissingjar") != null && this.getState().getGenMissing().countMissing() > 0) {
            GenMissing gen = this.getState().getGenMissing();
            String jarName = this.getOpts().getString("-genmissingjar");
            try {
                this.msg(this.mkMsg.m("writing  : jar {0}", jarName));
                FileOutputStream out = new FileOutputStream(jarName);
                ZipOutputStream jarFile = new ZipOutputStream(out);
                gen.generateAll(jarFile);
                jarFile.close();
                out.close();
                this.add(1002, new FileInputStream(jarName), jarName, myOpts);
            }
            catch (IOException ioex) {
                this.err(ioex, this.mkMsg.m("generating {0}", jarName));
            }
        } else if (this.getOpts().getBoolean("-genmissing")) {
            GenMissing gen = this.getState().getGenMissing();
            Iterator m = gen.missing();
            while (m.hasNext()) {
                String className = (String)m.next();
                ByteArrayOutputStream b = new ByteArrayOutputStream();
                gen.generate(className, b);
                this.add(this.ioCopy.toInputStream(b.toByteArray()), className + ".class", myOpts);
            }
        }
    }

    void createWrappers() {
        Publish publish = this.getState().getPublish();
        publish.publishPackages();
    }

    void doNativeCompile() {
        if (!this.getOpts().getBoolean("-nativecompile")) {
            return;
        }
        JdbcOperations jdbc = this.getState().getJdbc();
        boolean verbose = this.getState().getLog().getOpts().getVerbose();
        for (SchemaObject so : this.schemaObjects) {
            Object result;
            if (so.getType() != 29) continue;
            String qname = so.getPerhapsJarQualifiedName();
            String schema = so.getSchema();
            String query = "dbms_java.compile_class(" + (schema == null ? "" : "'" + schema + "', ") + "'" + qname + "')";
            if (verbose) {
                this.msg(this.mkMsg.m("natively compiling: {0}", so.toString()));
            }
            Enumeration results = jdbc.executeSelect(query, "dual", "1 = 1", "natively compiling class");
            int num_compiled = 0;
            if (results.hasMoreElements() && (result = results.nextElement()) instanceof BigDecimal) {
                num_compiled = ((BigDecimal)result).intValue();
            }
            this.getState().natively_compiled += num_compiled;
        }
    }

    public void process() throws ToolsException {
        this.processDeferredFiles();
        this.createMissingClasses();
        this.createWrappers();
        if (this.getState().getLoc() == 0 || this.getOpts().getBoolean("-noserverside")) {
            this.msgIfTimed("Querying shortnames en masse");
            int nnameless = 0;
            SchemaObject head = null;
            Enumeration objs = this.schemaObjects.elements();
            while (objs.hasMoreElements()) {
                SchemaObject obj = (SchemaObject)objs.nextElement();
                if (obj.shortnameKnown()) continue;
                ++nnameless;
                obj.next = head;
                head = obj;
            }
            if (nnameless > 10) {
                this.getState().populateShortnameTable(nnameless);
                this.getState().recordShortnames(head);
            }
        }
        this.msgIfTimed("Resolution and other processing");
        Enumeration objs = this.schemaObjects.elements();
        while (objs.hasMoreElements()) {
            this.checkCancelled();
            SchemaObject obj = (SchemaObject)objs.nextElement();
            try {
                obj.process2();
                if (obj.failure() == null) continue;
                obj.deleteMD5();
            }
            catch (SchemaObject.SchemaObjectError nex) {
                this.err(nex, this.mkMsg.m("processing {0}", obj.toString()));
            }
        }
        this.msgIfTimed("Processing sers");
        Enumeration sers = this.serObjects.elements();
        while (sers.hasMoreElements()) {
            SchemaObject ser = (SchemaObject)sers.nextElement();
            ser.process1();
            ser.process2();
        }
        this.getState().getJdbc().executeDDL("COMMIT", "committing changes");
        this.getState().setVerifier(true);
        if (this.getOpts().getBoolean("-nativecompile")) {
            this.doNativeCompile();
        }
        this.msgIfTimed("Error summary");
        boolean ok = this.summary();
        if (!ok) {
            throw new ToolsException("Failures occurred during processing");
        }
        this.msgIfTimed("Done");
    }

    public void cancel(String msg) {
        this.getState().setCancelled(msg);
    }

    void checkCancelled() {
        this.getState().checkCancelled();
    }

    public void finish() {
        this.reset();
    }

    public void processFinish() throws ToolsException {
        this.process();
    }

    boolean summary() {
        boolean ok = this.summary(this.schemaObjects.elements(), true);
        ok = this.summary(this.serObjects.elements(), ok);
        return ok;
    }

    boolean summary(Enumeration objs, boolean header) {
        while (objs.hasMoreElements()) {
            SchemaObject obj = (SchemaObject)objs.nextElement();
            String failure = obj.failure();
            if (failure == null) continue;
            if (header) {
                this.failErr(this.mkMsg.m("The following operations failed"));
                header = false;
            }
            this.failErr("    " + obj + ": " + failure);
        }
        return header;
    }

    void msg(String msg) {
        this.getState().msg(msg);
    }

    void msgIfTimed(String msg) {
        if (this.getState().getLog().getOpts().getTime()) {
            this.getState().msg(msg);
        }
    }

    void err(Exception ex, String when) {
        this.getState().err(ex, when);
    }

    void err(String msg) {
        this.getState().err(msg);
    }

    void failErr(String msg) {
        this.getState().failErr(msg);
    }

    void warn(String msg) {
        this.getState().warn(msg);
    }

    void usageErr(String msg) {
        this.err(msg);
        ++this.usageErrorCount;
    }

    void usageMessage() {
        this.err("loadjava: " + LoadJavaOptions.usageMessage());
    }

    public void setOutput(PrintWriter output) {
        this.getState().getLog().setWriter(output);
    }

    public void setLog(LoadJavaLog log) {
        this.getState().setLog(log);
    }

    public void setConnection(Connection conn) {
        this.getState().setConnection(conn);
    }

    public void setDatabase(DatabaseOptions db) {
        if (db != null) {
            this.getState().setDatabase(db);
        }
    }

    public void setBound(boolean b) {
        this.set("-definers", new Boolean(b));
    }

    public void setCreateSynonym(boolean createSyn) {
        this.set("-synonym", new Boolean(createSyn));
    }

    public void setDefiners(boolean b) {
        this.set("-definers", new Boolean(b));
    }

    public void setEncoding(String encoding) {
        this.set("-encoding", encoding);
    }

    public void setForceLoading(boolean forceLoading) {
        this.set("-force", new Boolean(forceLoading));
    }

    public void setResolve(boolean resolve) {
        this.set("-resolve", new Boolean(resolve));
    }

    public void setResolver(String resolver) {
        this.set("-resolver", resolver);
    }

    public void setSchema(String schema) {
        this.set("-schema", schema);
    }

    public void setVerbose(boolean verbose) {
        this.set("-verbose", new Boolean(verbose));
    }

    public static void main(String[] argv) {
        try {
            LoadJava lj = new LoadJava();
            lj.command(argv);
        }
        catch (ToolsError ex) {
            System.out.println("Aborting because of " + ex);
        }
        catch (ToolsException ex) {
            System.out.println("Completed with errors: " + ex.getMessage());
        }
    }

    void finalizer() {
        this.reset();
    }
}

