/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import oracle.aurora.rdbms.Handle;
import oracle.aurora.rdbms.ObjectTypeChangedException;
import oracle.aurora.rdbms.Schema;
import oracle.sql.RAW;

class HandleMd5 {
    HandleMd5() {
    }

    static RAW get(Schema schema, String objectName, int objectType) {
        Handle h = Handle.lookup(objectName, schema, objectType);
        if (h != null) {
            try {
                return new RAW(h.getMD5());
            }
            catch (ObjectTypeChangedException ex) {
                // empty catch block
            }
        }
        return null;
    }

    public static RAW get(String schemaName, String objectName, int objectType) {
        return HandleMd5.get(Schema.lookup(schemaName), objectName, objectType);
    }

    public static RAW get(String objectName, int objectType) {
        return HandleMd5.get(Schema.currentSchema(), objectName, objectType);
    }
}

