/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms.security;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import oracle.aurora.rdbms.Handle;
import oracle.aurora.rdbms.KGEException;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.rdbms.SharedDataHandle;
import oracle.jdbc.driver.OracleDriver;

class VersionedObject {
    private static final String TABLE_SUFFIX = "TABLE";
    private static final String VSEPARATOR = "$";
    private static Connection sqlConnection;
    private String tableName;
    private Schema schema;
    private String name;
    private int version;
    private Object object;
    private HashSet inUse;
    private boolean prepared;
    private int newVersion;
    private Refresher refresher;

    private static Connection sqlConnection() throws SQLException {
        if (sqlConnection == null) {
            sqlConnection = new OracleDriver().defaultConnection();
        }
        return sqlConnection;
    }

    private String tableName() {
        if (this.tableName == null) {
            this.tableName = this.sqlName(this.vName(TABLE_SUFFIX));
        }
        return this.tableName;
    }

    private HashSet inUse() {
        if (this.inUse == null) {
            this.inUse = new HashSet();
            if (this.object != null) {
                this.inUse.add(new Integer(this.version));
            }
        }
        return this.inUse;
    }

    VersionedObject(Schema schema, String name) {
        if (name == null || name.length() > 256 || name.indexOf(34) > -1 || name.indexOf(39) > -1 || name.indexOf(32) > -1 || name.indexOf(42) > -1 || name.indexOf(47) > -1 || name.indexOf(40) > -1 || name.indexOf(41) > -1 || name.indexOf(35) > -1 || name.indexOf(10) > -1 || name.indexOf(9) > -1 || name.indexOf(8) > -1 || name.indexOf(45) > -1 || name.indexOf(63) > -1 || name.indexOf(59) > -1) {
            throw new Error("Invalid VersionedObject name: " + name);
        }
        this.schema = schema;
        this.name = name;
        try {
            sqlConnection = new OracleDriver().defaultConnection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.refresh();
    }

    VersionedObject(Schema schema, String name, Connection connection) {
        this.schema = schema;
        this.name = name;
        sqlConnection = connection;
        this.refresh();
    }

    ResultSet sqlQuery(String q) throws SQLException {
        Statement s = null;
        try {
            s = VersionedObject.sqlConnection().createStatement();
            ResultSet rs = s.executeQuery(q);
            return rs;
        }
        catch (SQLException sql) {
            s.close();
            throw sql;
        }
    }

    void sqlClose(ResultSet rs) {
        if (rs != null) {
            try {
                Statement stmt = rs.getStatement();
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    void sqlExecute(String u) throws SQLException {
        Statement stmt = VersionedObject.sqlConnection().createStatement();
        try {
            stmt.executeUpdate(u);
        }
        catch (SQLException sql) {
            throw sql;
        }
        finally {
            stmt.close();
        }
    }

    int currentVersion() {
        return this.version;
    }

    Object get() {
        return this.object;
    }

    synchronized void prepareForReplace() {
        if (!this.prepared) {
            try {
                this.lock();
                this.newVersion = this.latest() + 1;
                this.sqlExecute("INSERT INTO " + this.tableName() + " VALUES( " + this.newVersion + ")");
                this.prepared = true;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    synchronized void replace(Object newObject) {
        this.prepareForReplace();
        if (this.prepared) {
            try {
                this.version = this.newVersion;
                this.createVersion(this.version, newObject);
                this.dropVersions(this.existingVersions().iterator());
            }
            catch (RuntimeException ex) {
                try {
                    VersionedObject.sqlConnection().rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw ex;
            }
            finally {
                this.prepared = false;
                this.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    HashSet existingVersions() {
        HashSet<Integer> s = new HashSet<Integer>();
        ResultSet rs = null;
        try {
            rs = this.sqlQuery("SELECT VERSION FROM " + this.tableName() + " FOR UPDATE ");
            while (true) {
                if (!rs.next()) {
                    this.sqlClose(rs);
                    return s;
                }
                int version = rs.getInt(1);
                s.add(new Integer(version));
            }
        }
        catch (SQLException sQLException) {
            return s;
        }
        finally {
            this.sqlClose(rs);
        }
    }

    void dropVersions(Iterator toBeDeleted) {
        while (toBeDeleted.hasNext()) {
            SharedDataHandle h;
            Integer version = (Integer)toBeDeleted.next();
            if (this.inUse().contains(version) || (h = this.getHandle(version)) == null) continue;
            try {
                h.drop(true);
                this.sqlExecute("DELETE FROM " + this.tableName() + " WHERE VERSION = " + version);
            }
            catch (KGEException kge) {
            }
            catch (SQLException ignore) {}
        }
    }

    private native Object getLatestObject();

    void refresh() {
        this.object = this.getLatestObject();
        this.inUse();
    }

    void refreshSlow() {
        this.version = this.latest();
        Object newObject = null;
        try {
            if (this.version > 0) {
                newObject = this.getVersion(this.version);
            }
        }
        catch (ClassNotFoundException ex) {
            newObject = this.refresher != null ? this.refresher.get() : null;
        }
        this.object = newObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int latest() {
        ResultSet m = null;
        int v = 0;
        try {
            m = this.sqlQuery("SELECT max(version) FROM " + this.tableName());
            if (m.next()) {
                v = m.getInt(1);
            }
            this.sqlClose(m);
            return v;
        }
        catch (SQLException sQLException) {
            return v;
        }
        finally {
            this.sqlClose(m);
        }
    }

    void createVersion(int versionNumber, Object newObject) {
        String sroName = this.vName(versionNumber);
        try {
            SharedDataHandle h = SharedDataHandle.createReplacable(sroName, this.schema, newObject, true, true);
            this.inUse().add(new Integer(versionNumber));
        }
        catch (KGEException kge) {
            throw new RuntimeException(kge.toString());
        }
    }

    SharedDataHandle getHandle(int version) {
        String sroName = this.vName(version);
        SharedDataHandle h = Handle.lookupSharedData(sroName, this.schema, true);
        if (h != null) {
            this.inUse().add(new Integer(version));
        }
        return h;
    }

    Object getVersion(int versionNumber) throws ClassNotFoundException {
        SharedDataHandle h = this.getHandle(versionNumber);
        if (h == null || h.status() != 1) {
            throw new ClassNotFoundException("Versioned Object " + this.name + "<" + versionNumber + ">");
        }
        Object result = h.access();
        return result;
    }

    String vName(String suffix) {
        return this.name + VSEPARATOR + suffix;
    }

    String vName(int suffix) {
        String hexName = "00000000" + Integer.toHexString(suffix);
        hexName = hexName.substring(hexName.length() - 8);
        return this.vName(hexName);
    }

    String sqlName(String v) {
        return "\"" + this.schema.toString() + "\".\"" + v + "\"";
    }

    void lock() throws SQLException {
        this.sqlExecute("LOCK TABLE " + this.tableName() + " IN EXCLUSIVE MODE");
    }

    void release() {
        try {
            VersionedObject.sqlConnection().commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    static interface Refresher {
        public Object get();
    }
}

