/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms.security;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Enumeration;
import java.util.HashMap;
import oracle.aurora.rdbms.security.PolicyTable;
import oracle.aurora.vm.Id;

public class PolicyTableProxy
extends PermissionCollection {
    private Id schema;
    private long timeStamp;
    private TableGetter tableGetter;
    private PermissionCollection permissions;
    private HashMap typePermissions;

    public PolicyTableProxy(Id schema, TableGetter tableGetter) {
        this.schema = schema;
        this.tableGetter = tableGetter;
        this.typePermissions = new HashMap();
        this.setReadOnly();
    }

    public String toString() {
        return "PolicyTableProxy(" + this.schema + ")";
    }

    public void add(Permission permission) {
    }

    public boolean implies(Permission permission) {
        boolean result = this.getPermissionsFor(permission).implies(permission);
        return result;
    }

    public Enumeration elements() {
        return this.getPermissions().elements();
    }

    public PermissionCollection getPermissionsFor(Permission implicand) {
        Class<?> pClass = implicand.getClass();
        Type typePermission = (Type)this.typePermissions.get(pClass);
        if (typePermission == null) {
            typePermission = new Type(implicand);
            this.typePermissions.put(pClass, typePermission);
        }
        return typePermission;
    }

    public PermissionCollection getPermissions() {
        if (this.permissions == null || this.tableChanged()) {
            PolicyTable table = this.getTable();
            if (table == null) {
                this.permissions = new Permissions();
            }
            this.permissions = table.getPermissionsFor(this.schema);
        }
        return this.permissions;
    }

    PolicyTable getTable() {
        return this.tableGetter.table();
    }

    boolean tableChanged() {
        boolean result = false;
        long newTime = this.getTable().getTimeStamp();
        if (newTime != this.timeStamp) {
            this.timeStamp = newTime;
            result = true;
        }
        return result;
    }

    public static interface TableGetter {
        public PolicyTable table();
    }

    class Type
    extends PermissionCollection {
        private Permission type;
        private PermissionCollection granted;

        Type(Permission type) {
            this.type = type;
        }

        PolicyTableProxy getProxy() {
            return PolicyTableProxy.this;
        }

        public Enumeration elements() {
            throw new Error("Not Yet Implemented");
        }

        public void add(Permission permission) {
        }

        public boolean implies(Permission implicand) {
            if (this.granted == null || PolicyTableProxy.this.tableChanged()) {
                PolicyTable table = PolicyTableProxy.this.getTable();
                if (table == null) {
                    return false;
                }
                this.granted = table.getPermissions(PolicyTableProxy.this.schema, implicand);
            }
            return this.granted.implies(implicand);
        }

        public String toString() {
            return "PolicyTableProxy.Type(" + PolicyTableProxy.this.schema + "," + this.type + ")";
        }
    }
}

