/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.notinserver;

import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Vector;
import oracle.aurora.compiler.CompilerInterface;
import oracle.aurora.compiler.Destination;
import oracle.aurora.compiler.ErrorPosition;
import oracle.aurora.compiler.ErrorReporter;
import oracle.aurora.compiler.ExternalEntity;
import oracle.aurora.compiler.FinderFactory;
import oracle.aurora.compiler.MemoizedFinderFactory;
import oracle.aurora.compiler.QName;
import oracle.aurora.compiler.SimpleErrorReporter;
import oracle.aurora.compiler.TooManyErrorsException;
import oracle.aurora.notinserver.ExternalSourceFile;
import oracle.aurora.notinserver.FileDestination;
import oracle.aurora.notinserver.FileFinder;
import sun.tools.java.ClassPath;

public class FileInterface
implements CompilerInterface {
    String classPathString;
    String destDirPrefix;
    PrintWriter out;
    ClassPath classPath;
    ErrorReporter errorReporter;

    public FileInterface(String classPathString) {
        this.setClassPathString(classPathString);
    }

    public Writer getLog() {
        if (this.out == null) {
            this.out = new PrintWriter(System.out, true);
        }
        return this.out;
    }

    public FinderFactory getFinderFactory() {
        return new MemoizedFinderFactory(new FileFinder(this.getClassPath()));
    }

    public ErrorReporter getReporter() {
        if (this.errorReporter == null) {
            this.errorReporter = new SimpleErrorReporter(this.getLog());
        }
        return this.errorReporter;
    }

    public Destination getDestination(ExternalEntity source, QName what, int kind) {
        String suffix = kind == 0 ? ".java" : (kind == 1 ? ".class" : (kind == 2 ? ".properties" : ""));
        return this.getDestination(source, what, suffix);
    }

    private Destination getDestination(ExternalEntity source, QName what, String suffix) {
        String filePrefix;
        String dirPrefix;
        if (this.destDirPrefix == null) {
            dirPrefix = source.getPath();
            int index = dirPrefix.lastIndexOf(File.separatorChar);
            dirPrefix = index >= 0 ? dirPrefix.substring(0, index) : "";
            filePrefix = what.getFlatName();
        } else {
            dirPrefix = this.destDirPrefix;
            filePrefix = what.getName().replace('.', File.separatorChar);
        }
        filePrefix = filePrefix.replace('|', '.');
        FileDestination destination = new FileDestination(dirPrefix + File.separatorChar + filePrefix + suffix);
        return destination;
    }

    void report(int level, String msg) {
        try {
            this.getReporter().report(ErrorPosition.none(), level, msg);
        }
        catch (TooManyErrorsException tooManyErrorsException) {
            // empty catch block
        }
    }

    public int interpretArg(String[] argv, int argc, Vector sources) {
        if (argc >= argv.length) {
            return argc;
        }
        String arg = argv[argc];
        int remaining = argv.length - argc;
        int consume = 0;
        boolean ok = true;
        if (arg.endsWith(".java") || arg.endsWith(".sqlj")) {
            sources.addElement(new ExternalSourceFile(arg));
            consume = 1;
        } else if (arg.equals("-classpath") && remaining >= 2) {
            this.setClassPathString(argv[argc + 1]);
            consume = 2;
        } else if (arg.equals("-classpath+") && remaining >= 2) {
            this.setClassPathString(this.classPathString + File.pathSeparator + argv[argc + 1]);
            consume = 2;
        } else if (arg.equals("-d") && remaining >= 2) {
            ok = this.setDestDir(argv[argc + 1]);
            consume = 2;
        } else if (arg.charAt(0) != '-') {
            arg = arg.replace(File.separatorChar, '.');
            QName name = new QName(arg);
            ExternalEntity entity = this.getFinderFactory().finder(null).find(name, 0);
            if (entity != null) {
                sources.addElement(entity);
                consume = 1;
            } else {
                this.report(2, "could not find source for " + name);
            }
        }
        return ok ? argc + consume : -1;
    }

    public void close() {
    }

    boolean setDestDir(String destDirString) {
        if ((destDirString = destDirString.replace('/', File.separatorChar)).endsWith(File.separator)) {
            destDirString = destDirString.substring(0, destDirString.length() - 1);
        }
        File destDirFile = new File(destDirString);
        boolean ok = true;
        try {
            if (!destDirFile.exists()) {
                this.getReporter().report(ErrorPosition.none(), 2, destDirString + " does not exist");
                ok = false;
            } else if (!destDirFile.isDirectory()) {
                this.getReporter().report(ErrorPosition.none(), 2, destDirString + " is not a directory");
                ok = false;
            }
        }
        catch (TooManyErrorsException ex) {
            // empty catch block
        }
        this.destDirPrefix = destDirString + File.separator;
        return ok;
    }

    boolean setClassPathString(String classPathString) {
        if (classPathString == null) {
            classPathString = System.getProperty("java.class.path");
        }
        this.classPathString = classPathString;
        this.classPath = null;
        return true;
    }

    ClassPath getClassPath() {
        if (this.classPath == null) {
            this.classPath = new ClassPath(this.classPathString);
        }
        return this.classPath;
    }
}

