/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.notinserver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import oracle.aurora.compiler.ExternalEntity;
import oracle.aurora.compiler.QName;
import sun.tools.java.ClassFile;

public class ExternalClassFile
extends ExternalEntity {
    ClassFile file;
    QName name;
    int kind;
    String pkg;

    public ExternalClassFile(ClassFile file, QName name, int kind) {
        super(kind);
        this.file = file;
        this.name = name;
        this.kind = kind;
    }

    public boolean isKind(int kind) {
        return kind == this.kind;
    }

    public Reader getReader() throws IOException {
        InputStreamReader reader = null;
        if (reader == null && this.kind == 0) {
            InputStream in = this.getStream();
            reader = new InputStreamReader(this.getStream());
        }
        return reader;
    }

    public InputStream getStream() throws IOException {
        return this.file.getInputStream();
    }

    public String getEncoding() {
        return null;
    }

    public Class getLoadedClass() {
        return null;
    }

    public QName getQualifiedName() {
        return this.name;
    }

    public String getPath() {
        return this.file.getAbsoluteName();
    }

    public String getNameForClassFile() {
        String name = this.file.getPath();
        int x = name.lastIndexOf(File.separatorChar);
        if (x >= 0) {
            name = name.substring(x + 1);
        }
        return name;
    }

    public String toString() {
        return this.getPath();
    }

    public boolean equals(Object otherObject) {
        boolean result = false;
        if (otherObject instanceof ExternalClassFile) {
            ExternalClassFile other = (ExternalClassFile)otherObject;
            result = this.getPath().equals(other.getPath());
        }
        return result;
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    ClassFile getClassFile() {
        return this.file;
    }

    public void setPackage(String pkg) {
        this.pkg = pkg;
        if (this.name == null) {
            this.name = new QName(pkg, "");
        }
    }
}

