/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.memoryManager.weak;

import java.util.Enumeration;
import oracle.aurora.memoryManager.weak.WeakHashtable;

class WeakHashtableEnumeration
implements Enumeration {
    private int nextIndex;
    private final boolean enumerateKeys;
    private final WeakHashtable table;

    WeakHashtableEnumeration(WeakHashtable tbl, boolean key) {
        this.enumerateKeys = key;
        this.table = tbl;
        this.nextIndex = this.table.nextIndex(-1);
        if (this.nextIndex < -1) {
            this.nextIndex = -1;
        }
    }

    public boolean hasMoreElements() {
        return this.nextIndex != -1;
    }

    public Object nextElement() {
        int nextNext = this.table.nextIndex(this.nextIndex);
        Object elt = this.enumerateKeys ? this.table.indexKey(this.nextIndex) : this.table.indexValue(this.nextIndex);
        this.nextIndex = nextNext > this.nextIndex ? nextNext : -1;
        return elt;
    }
}

