/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.genmsg;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import oracle.aurora.genmsg.GenMsgOptions;
import oracle.aurora.util.msg.Msg;

public class Generate {
    private GenMsgOptions opts;
    private Msg msg;
    private PrintStream out;
    static final String[] prefix = new String[]{"/* This source generated by GenMsg */", "", "import java.util.ListResourceBundle;", "", "public class Messages extends ListResourceBundle {", "", "    public Object[][] getContents() { return contents; }", "", "    /* In the original version of this class ", "     * the same String is used for the key and the message.", "     * Only the key (the second String in each pair)", "     * should be translated.", "     */", "", "    static final Object[][] contents = {", null};
    static final String[] suffix = new String[]{"    };", "}", null};

    Generate(GenMsgOptions opts) {
        this.opts = opts;
        this.msg = new Msg("");
    }

    synchronized void generate(Map map, OutputStream ostream) throws IOException {
        this.out = new PrintStream(ostream);
        this.outputPrefix();
        for (Map.Entry e : map.entrySet()) {
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            this.out.println("    { \"" + key + "\", ");
            this.outputValue(value);
        }
        this.outputSuffix();
        this.out.flush();
    }

    void outputValue(String value) {
        if (value.indexOf("\\n") < 0) {
            this.out.println("         \"" + value + "\" }, ");
        } else {
            int xFrom = 0;
            int xNext = value.indexOf("\\n", xFrom);
            while (xNext > 0) {
                String part = value.substring(xFrom, xNext + 2);
                this.out.println("         \"" + part + "\" +");
                xFrom = xNext + 2;
                xNext = value.indexOf("\\n", xFrom);
            }
            String terminal = value.substring(xFrom);
            this.out.println("         \"" + terminal + "\" }, ");
        }
    }

    void outputPrefix() {
        this.out.println("package " + this.opts.getPackage() + ";");
        this.output(prefix);
    }

    void outputSuffix() {
        this.output(suffix);
    }

    void output(String[] strings) {
        for (int x = 0; x < strings.length; ++x) {
            if (strings[x] == null) continue;
            this.out.println(strings[x]);
        }
    }

    public static void main(String[] arg) throws IOException {
        GenMsgOptions opts = new GenMsgOptions();
        opts.parseArgs(arg);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("eKey", "an error has occurred");
        Generate gen = new Generate(opts);
        gen.generate(map, System.out);
    }
}

