/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.completion.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.ide.insight.InsightItem;
import oracle.ide.insight.completion.CompletionModel;
import oracle.ide.insight.completion.ui.InsightViewCustomizer;
import oracle.javatools.ui.AttributedStringBuilder;

public class InsightCellRenderer<T extends InsightItem>
extends DefaultListCellRenderer {
    private static final int GAP = 36;
    private static final Color HIGHLIGHT_MATCHING_BG = new Color(255, 255, 255, 70);
    private static final int MAX_WIDTH = 800;
    private static final int MIN_NAME_DESC_GAP = 24;
    private AttributedString description = AttributedStringBuilder.EMPTY_ATTRIBUTED_STRING;
    private final Stroke SEPARATOR_STROKE = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 2.0f);
    private AttributedString aText = null;
    private CustomAttributedString renderName = null;
    private CustomAttributedString renderDescription = null;
    private final CompletionModel model;
    private boolean lastItemInGroup = false;
    private Color regularBackground;
    private Color preferredBackground;
    private Color preferredSelBackground;

    public InsightCellRenderer(InsightViewCustomizer customizer) {
        this.regularBackground = customizer.getRegularBackground();
        this.preferredBackground = customizer.getPreferredBackground();
        this.preferredSelBackground = customizer.getPreferredSelectionBackground();
        this.model = customizer.getInsightContext().getModel();
        this.setOpaque(true);
    }

    protected void setAttributedText(AttributedString aText) {
        this.aText = aText;
    }

    protected AttributedString getAttributedText() {
        return this.aText;
    }

    protected void setDescription(AttributedString description) {
        this.description = description;
    }

    protected AttributedString getDescription() {
        return this.description;
    }

    protected void customize(T item) {
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        InsightItem nextItem;
        TextLayout layout;
        Graphics2D g;
        String matchingText;
        AttributedString aDesc;
        AttributedString aName;
        InsightItem item = (InsightItem)value;
        this.customize(item);
        if (!SwingUtilities.isEventDispatchThread()) {
            AccessibleContext ac = this.getAccessibleContext();
            if (ac != null) {
                ac.setAccessibleName(item.getAccessibleText());
            }
            return this;
        }
        Color background = item.getGroup() == 50 ? this.preferredBackground : this.regularBackground;
        Color selBackground = item.getGroup() == 50 ? this.preferredSelBackground : list.getSelectionBackground();
        this.setBackground(isSelected ? selBackground : background);
        this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
        FontMetrics fm = list.getFontMetrics(list.getFont());
        int width = 0;
        if (this.getName() == null) {
            width = SwingUtilities.computeStringWidth(fm, this.getText());
        }
        if ((aName = this.getAttributedText()) == null) {
            aName = new AttributedString(item.getName());
        }
        if ((aDesc = this.getDescription()) == null) {
            aDesc = new AttributedString("");
        }
        this.renderName = new CustomAttributedString(aName.getIterator());
        this.renderDescription = new CustomAttributedString(aDesc.getIterator());
        if (isSelected) {
            this.renderName.addAttribute(TextAttribute.FOREGROUND, this.getForeground());
            if (this.renderDescription.length() > 0) {
                this.renderDescription.addAttribute(TextAttribute.FOREGROUND, this.getForeground());
            }
        }
        if ((matchingText = this.model.getMatchingText()) != null && matchingText.length() > 0) {
            matchingText = matchingText.toLowerCase();
            String text = AttributedStringBuilder.toString((AttributedString)this.renderName).toLowerCase();
            int matchI = text.indexOf(matchingText);
            if (matchI > -1) {
                this.renderName.addAttribute(TextAttribute.BACKGROUND, HIGHLIGHT_MATCHING_BG, matchI, matchI + matchingText.length());
            }
        }
        FontRenderContext frc = (g = (Graphics2D)this.getGraphics()) == null ? new FontRenderContext(null, true, true) : g.getFontRenderContext();
        AttributedCharacterIterator nameIt = this.renderName.getIterator();
        if (nameIt.getEndIndex() > 0) {
            LineBreakMeasurer lbm = new LineBreakMeasurer(this.renderName.getIterator(), frc);
            layout = lbm.nextLayout(10000.0f);
            width = (int)layout.getVisibleAdvance() + 1;
        }
        width += 36;
        if (this.renderDescription.getIterator().getEndIndex() > 0) {
            LineBreakMeasurer descLbm = new LineBreakMeasurer(this.renderDescription.getIterator(), frc);
            layout = descLbm.nextLayout(10000.0f);
            width += (int)layout.getVisibleAdvance() + 1;
        }
        if (this.getIcon() != null) {
            width += this.getIconTextGap() + this.getIcon().getIconWidth();
        }
        Insets i = this.getInsets();
        width = width + i.left + i.right;
        width = Math.min(800, width);
        this.lastItemInGroup = false;
        if (index < list.getModel().getSize() - 1 && (nextItem = (InsightItem)list.getModel().getElementAt(index + 1)).getGroup() != item.getGroup()) {
            this.lastItemInGroup = true;
        }
        int height = fm.getMaxAscent() + fm.getMaxDescent() + 1 + i.top + i.bottom;
        if (this.lastItemInGroup) {
            ++height;
        }
        this.setPreferredSize(new Dimension(width, height));
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        LineBreakMeasurer lbm;
        Insets i = this.getInsets();
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setColor(this.getForeground());
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FontRenderContext frc = g2 == null ? new FontRenderContext(null, true, true) : g2.getFontRenderContext();
        int y = g.getFontMetrics().getAscent() + i.top;
        int x = i.left;
        Icon icon = this.getIcon();
        if (icon != null) {
            icon.paintIcon(this, g2, x, i.top);
            x += icon.getIconWidth() + this.getIconTextGap();
        }
        int nameWidth = this.getAStringWidth(this.renderName, frc);
        int descWidth = this.getAStringWidth(this.renderDescription, frc);
        int nameMaxWidth = Math.max(20, this.getWidth() - i.right - x - descWidth - 24);
        if (nameWidth > nameMaxWidth) {
            lbm = new LineBreakMeasurer(this.renderName.getIterator(), BreakIterator.getCharacterInstance(), frc);
            TextLayout nameLayout = lbm.nextLayout(nameMaxWidth);
            nameLayout.draw(g2, x, y);
            g2.drawString("...", (float)x + nameLayout.getAdvance() + 1.0f, (float)y);
        } else if (nameWidth > 0) {
            lbm = new LineBreakMeasurer(this.renderName.getIterator(), frc);
            TextLayout nameLayout = lbm.nextLayout(10000.0f);
            nameLayout.draw(g2, x, y);
        }
        if (descWidth > 0) {
            g2.drawString(this.renderDescription.getIterator(), this.getWidth() - descWidth - i.right, y);
        }
        if (this.lastItemInGroup) {
            g2.setColor(UIManager.getColor("List.dropLineColor"));
            g2.setStroke(this.SEPARATOR_STROKE);
            int h = this.getHeight() - 1;
            g2.drawLine(0, h, this.getWidth(), h);
        }
        g2.dispose();
    }

    private int getAStringWidth(CustomAttributedString aText, FontRenderContext frc) {
        if (aText.length() == 0) {
            return 0;
        }
        LineBreakMeasurer lbm = new LineBreakMeasurer(aText.getIterator(), frc);
        TextLayout layout = lbm.nextLayout(10000.0f);
        int width = (int)layout.getVisibleAdvance() + 1;
        return width;
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
    }

    private final class CustomAttributedString
    extends AttributedString {
        int length;

        public CustomAttributedString(AttributedCharacterIterator text) {
            super(text);
            this.length = 0;
            this.length = text.getEndIndex();
        }

        @Override
        public void addAttribute(AttributedCharacterIterator.Attribute attribute, Object value) {
            if (this.length() > 0) {
                super.addAttribute(attribute, value);
            }
        }

        @Override
        public void addAttribute(AttributedCharacterIterator.Attribute attribute, Object value, int beginIndex, int endIndex) {
            if (this.length() > 0) {
                super.addAttribute(attribute, value, beginIndex, endIndex);
            }
        }

        @Override
        public void addAttributes(Map<? extends AttributedCharacterIterator.Attribute, ?> attributes, int beginIndex, int endIndex) {
            if (this.length() > 0) {
                super.addAttributes(attributes, beginIndex, endIndex);
            }
        }

        int length() {
            return this.getIterator().getEndIndex();
        }
    }
}

