/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.ui;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.dbtools.raptor.report.ui.ReportTreeContext;

public abstract class ReportTreeNode {
    private ReportTreeContext context;
    private DefaultMutableTreeNode jNode;
    private ReportTreeNode parentNode;
    private LinkedList<ReportTreeNode> childNodes;

    public ReportTreeNode(ReportTreeContext reportTreeContext) {
        this.context = reportTreeContext;
        this.jNode = new DefaultMutableTreeNode(this);
        this.childNodes = new LinkedList();
    }

    public ReportTreeContext context() {
        return this.context;
    }

    public String toString() {
        return this.typeLabel();
    }

    public abstract String typeLabel();

    public String name() {
        return this.context().name();
    }

    public String iconName() {
        return null;
    }

    public String title() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.typeLabel());
        String string = this.name();
        if (string != null && !string.isEmpty()) {
            stringBuffer.append(" - ").append(string);
        }
        return stringBuffer.toString();
    }

    public abstract JPanel panel();

    public void onSelection() {
    }

    public void insertAt(ReportTreeNode reportTreeNode, int n) {
        this.remove();
        this.parentNode = reportTreeNode;
        reportTreeNode.childNodes.add(n, this);
    }

    public void insertAtTail(ReportTreeNode reportTreeNode) {
        this.remove();
        this.parentNode = reportTreeNode;
        reportTreeNode.childNodes.addLast(this);
    }

    public void insertAtHead(ReportTreeNode reportTreeNode) {
        this.remove();
        this.parentNode = reportTreeNode;
        reportTreeNode.childNodes.addFirst(this);
    }

    public void insertBefore(ReportTreeNode reportTreeNode, ReportTreeNode reportTreeNode2) {
        this.remove();
        this.parentNode = reportTreeNode;
        int n = reportTreeNode.childNodes.indexOf(reportTreeNode2);
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        reportTreeNode.childNodes.add(n, this);
    }

    public void insertAfter(ReportTreeNode reportTreeNode, ReportTreeNode reportTreeNode2) {
        this.remove();
        this.parentNode = reportTreeNode;
        int n = reportTreeNode.childNodes.indexOf(reportTreeNode2);
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        reportTreeNode.childNodes.add(n + 1, this);
    }

    public void remove() {
        this.setVisible(false);
        if (this.parentNode != null) {
            this.parentNode.childNodes.remove(this);
            this.parentNode = null;
        }
    }

    public void close() {
        this.remove();
        this.cleanupAll();
    }

    protected void cleanup() {
    }

    public void setVisible(boolean bl) {
        if (this.jNode.getParent() == null && bl) {
            this.insertJNode();
        } else if (this.jNode.getParent() != null && !bl) {
            this.removeJNode();
        }
    }

    public boolean isVisible() {
        return this.jNode.getParent() != null;
    }

    public <C extends ReportTreeNode> C findChild(Class<C> clazz, String string) {
        return (C)this.findChild(string);
    }

    public ReportTreeNode findChild(String string) {
        ReportTreeNode reportTreeNode = null;
        for (ReportTreeNode reportTreeNode2 : this.childNodes) {
            if (!reportTreeNode2.toString().equals(string)) continue;
            reportTreeNode = reportTreeNode2;
            break;
        }
        return reportTreeNode;
    }

    public <C extends ReportTreeNode> List<C> childNodes(Class<C> clazz) {
        return this.childNodes();
    }

    public List<ReportTreeNode> childNodes() {
        return new ArrayList<ReportTreeNode>(this.childNodes);
    }

    public <C extends ReportTreeNode> C parentNode(Class<C> clazz) {
        return (C)this.parentNode();
    }

    public ReportTreeNode parentNode() {
        return this.parentNode;
    }

    protected void refreshJNode() {
        ((DefaultTreeModel)this.context().treePanel().getReportTree().getModel()).nodeChanged(this.jNode);
    }

    protected DefaultMutableTreeNode jNode() {
        return this.jNode;
    }

    private void insertJNode() {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.context().treePanel().getReportTree().getModel();
        int n = 0;
        for (ReportTreeNode reportTreeNode : this.parentNode.childNodes()) {
            if (reportTreeNode.equals(this)) break;
            if (reportTreeNode.jNode.getParent() == null) continue;
            ++n;
        }
        defaultTreeModel.insertNodeInto(this.jNode, this.parentNode.jNode, n);
    }

    private void removeJNode() {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.context().treePanel().getReportTree().getModel();
        defaultTreeModel.removeNodeFromParent(this.jNode);
    }

    private void cleanupAll() {
        for (ReportTreeNode reportTreeNode : this.childNodes) {
            reportTreeNode.cleanupAll();
        }
        this.cleanup();
    }
}

