/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.Document;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.report.ui.CustomCellRenderer;
import oracle.dbtools.raptor.report.ui.ReportArb;
import oracle.dbtools.raptor.report.ui.ReportSQLEditor;
import oracle.dbtools.raptor.report.ui.ReportTreeContext;
import oracle.dbtools.raptor.report.ui.SQLNode;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;

public class ReportSQLPanel
extends JPanel {
    public static final String SQL_VERSIONS = "SQL_VERSIONS";
    private static final long serialVersionUID = 1L;
    private ReportTreeContext _reportContext;
    private ReportSQLEditor sqlEditor;
    private BasicEditorPane _noneditableSQL;
    private JLabel nonEditSQLNameLabel;
    private JCheckBox _versions;
    private JPanel sqlPanel;
    private JPanel variantsPanel;
    private SQLNode _sqlNode;
    private JButton addVariantButton;
    private JButton removeVariantButton;
    private JTable _variantsTable;
    private DefaultTableModel _variantsModel;

    public ReportSQLPanel(ReportTreeContext reportTreeContext, SQLNode sQLNode) {
        this._sqlNode = sQLNode;
        this._reportContext = reportTreeContext;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.initializeSQLPanel();
        if (this._sqlNode.isMain()) {
            this.initializeVersionsCheck();
            this.initializeVariantsPanel();
        }
        this.configurePanel();
    }

    private void configurePanel() {
        this.removeAll();
        JPanel jPanel = null;
        jPanel = this._sqlNode.isMain() ? (this._versions != null && this._versions.isSelected() ? this.variantsPanel : this.sqlPanel) : this.sqlPanel;
        int n = 0;
        if (this._versions != null) {
            this.add((Component)this._versions, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        }
        this.add((Component)jPanel, new GridBagConstraints(0, n++, 1, 1, 1.0, 1.0, 23, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.revalidate();
        this.repaint();
    }

    private void initializeVersionsCheck() {
        this._versions = new JCheckBox(ReportArb.getString(SQL_VERSIONS));
        DisplayModel displayModel = this._reportContext.model();
        boolean bl = displayModel != null ? displayModel.getQueries().size() > 1 : false;
        this._versions.setSelected(this._sqlNode.variantsVisible());
        this._versions.setEnabled(!bl);
        this._reportContext.setSQLVariantsEnabled(this._versions.isSelected());
        this._versions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportSQLPanel.this._sqlNode.setVariantsVisible(ReportSQLPanel.this._versions.isSelected());
                ReportSQLPanel.this.configurePanel();
                ReportSQLPanel.this._reportContext.setSQLVariantsEnabled(ReportSQLPanel.this._versions.isSelected());
            }
        });
    }

    private void initializeSQLPanel() {
        this.sqlPanel = new JPanel(new GridBagLayout());
        Query query = this._sqlNode.query();
        String string = query != null ? query.getSql() : null;
        this.sqlEditor = new ReportSQLEditor(this._reportContext, string);
        this.sqlPanel.add((Component)this.sqlEditor, new GridBagConstraints(0, 1, 1, 4, 1.0, 1.0, 23, 1, new Insets(5, 0, 0, 0), 0, 0));
        if (this._reportContext.isChild()) {
            JPanel jPanel = this.createNonEditPanel();
            this.sqlPanel.add((Component)jPanel, new GridBagConstraints(0, 5, 1, 2, 1.0, 1.0, 23, 1, new Insets(5, 0, 0, 0), 0, 0));
        }
    }

    private JPanel createNonEditPanel() {
        this._noneditableSQL = EditorFactory.createIdeEditorPane();
        this.nonEditSQLNameLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this.nonEditSQLNameLabel, (Component)this._noneditableSQL, (String)ReportArb.format("MASTER_REPORT_NAME", this._reportContext.treePanel().getMasterReportName()));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.nonEditSQLNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._noneditableSQL.setDocument((Document)new BasicDocument("foo.plsql"));
        JScrollPane jScrollPane = new JScrollPane((Component)this._noneditableSQL, 22, 32);
        jScrollPane.setPreferredSize(this._noneditableSQL.getPreferredSize());
        jScrollPane.setSize(jScrollPane.getPreferredSize());
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 1, 2, 3, 1.0, 1.0, 23, 1, new Insets(6, 0, 0, 0), 0, 50));
        this._noneditableSQL.setText(this._reportContext.treePanel().getMasterReportSQL());
        this._noneditableSQL.setEditable(false);
        return jPanel;
    }

    private void initializeVariantsPanel() {
        this._variantsModel = new DefaultTableModel();
        this._variantsTable = new JTable(this._variantsModel){
            private static final long serialVersionUID = 1L;

            @Override
            public TableCellEditor getCellEditor(int n, int n2) {
                return new DefaultCellEditor(new JTextField());
            }

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                return new CustomCellRenderer();
            }
        };
        this._variantsTable.setBorder(new LineBorder(Color.LIGHT_GRAY));
        this._variantsModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                int n = tableModelEvent.getFirstRow();
                int n2 = tableModelEvent.getColumn();
                int n3 = tableModelEvent.getType();
                if (n3 == 0 && n2 >= 0) {
                    String string = (String)ReportSQLPanel.this._variantsModel.getValueAt(n, n2);
                    SQLNode sQLNode = ReportSQLPanel.this._sqlNode.childNodes(SQLNode.class).get(n);
                    if (n2 == 0) {
                        if (!string.trim().equals(sQLNode.minVersion()) && !sQLNode.setMinVersion(string)) {
                            ReportSQLPanel.this._variantsModel.setValueAt(sQLNode.minVersion(), n, n2);
                        }
                    } else if (!string.trim().equals(sQLNode.maxVersion()) && !sQLNode.setMaxVersion(string)) {
                        ReportSQLPanel.this._variantsModel.setValueAt(sQLNode.maxVersion(), n, n2);
                    }
                }
            }
        });
        this._variantsTable.setPreferredScrollableViewportSize(new Dimension(400, 300));
        this._variantsTable.setSelectionMode(0);
        this._variantsModel.addColumn(ReportArb.getString("SQL_VARIANT_MIN_VERSION"));
        this._variantsModel.addColumn(ReportArb.getString("SQL_VARIANT_MAX_VERSION"));
        this.variantsPanel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(this._variantsTable);
        this.variantsPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.addVariantButton = new JButton();
        this.addVariantButton.setText(ReportArb.getString("SQL_VARIANT_ADD_VARIANT"));
        this.addVariantButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportSQLPanel.this.addVariant();
            }
        });
        jPanel.add((Component)this.addVariantButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.removeVariantButton = new JButton();
        this.removeVariantButton.setText(ReportArb.getString("SQL_VARIANT_REMOVE_VARIANT"));
        this.removeVariantButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportSQLPanel.this.removeVariant();
            }
        });
        this.removeVariantButton.setEnabled(false);
        this._variantsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl = ReportSQLPanel.this._variantsTable.getSelectedRow() >= 0 && ReportSQLPanel.this._sqlNode.childNodes().size() > 1;
                ReportSQLPanel.this.removeVariantButton.setEnabled(bl);
            }
        });
        this.populateVariantModel(null);
        this._variantsTable.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (ReportSQLPanel.this._variantsTable.getEditingColumn() > -1 && ReportSQLPanel.this._variantsTable.getEditingRow() > -1) {
                    ReportSQLPanel.this._variantsTable.getCellEditor(ReportSQLPanel.this._variantsTable.getEditingRow(), ReportSQLPanel.this._variantsTable.getEditingColumn()).stopCellEditing();
                }
            }
        });
        jPanel.add((Component)this.removeVariantButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 10, 0, 0), 0, 0));
        jPanel.add(Box.createGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.variantsPanel.add((Component)jPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 0, 5, 0), 0, 0));
    }

    private void populateVariantModel(SQLNode sQLNode) {
        this._variantsModel.setRowCount(0);
        int n = -1;
        int n2 = 0;
        for (SQLNode sQLNode2 : this._sqlNode.childNodes(SQLNode.class)) {
            this._variantsModel.addRow(new Object[]{sQLNode2.minVersion(), sQLNode2.maxVersion()});
            if (sQLNode2.equals(sQLNode)) {
                n = n2;
            }
            ++n2;
        }
        if (n >= 0) {
            this._variantsTable.getSelectionModel().setSelectionInterval(-1, n);
        }
        this._versions.setEnabled(this._sqlNode.childNodes().size() < 2 || !this._versions.isSelected());
    }

    private void addVariant() {
        SQLNode sQLNode = this._sqlNode.addVariant();
        this.populateVariantModel(sQLNode);
    }

    private void removeVariant() {
        int n = this._variantsTable.getSelectedRow();
        this._sqlNode.childNodes().get(n).remove();
        this.populateVariantModel(null);
    }

    public void refreshSQL() {
        Query query = this._sqlNode.query();
        String string = query != null ? query.getSql() : null;
        this.sqlEditor.refreshSQL(string);
    }

    public String getSQL() {
        return this.sqlEditor.getSql();
    }

    public void setSQL(String string) {
        this.sqlEditor.refreshSQL(string);
    }

    public void updateMasterInfo() {
        if (this._reportContext.isChild()) {
            ResourceUtils.resLabel((JLabel)this.nonEditSQLNameLabel, (Component)this._noneditableSQL, (String)ReportArb.format("MASTER_REPORT_NAME", this._reportContext.treePanel().getMasterReportName()));
            this._noneditableSQL.setEditable(true);
            this._noneditableSQL.setText(this._reportContext.treePanel().getMasterReportSQL());
            this._noneditableSQL.setEditable(false);
        }
    }
}

