/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.Document;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.display.DisplayConstants;
import oracle.dbtools.raptor.controls.display.DisplayRegistry;
import oracle.dbtools.raptor.report.ui.ReportArb;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controls.Toolbar;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFilter;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.icons.OracleIcons;

public class ReportCreatePanel
extends JPanel
implements ActionListener {
    private JTextField _name;
    private JTextArea _desc;
    private JComboBox _style;
    private BasicEditorPane _sql;
    private JButton _btnOpenFile;
    private JButton _btnClearAll;
    private Toolbar _toolbar;
    private JEWTDialog _dlg;
    private static URL _lastUrl;

    public ReportCreatePanel() {
        this.init();
    }

    private void init() {
        Object object2;
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._name, (String)ReportArb.getString("NAME"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._desc, (String)ReportArb.getString("DESCRIPTION"));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._style, (String)ReportArb.getString("STYLE"));
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this._sql, (String)ReportArb.getString("SQL"));
        int n = 0;
        this._name = new JTextField();
        this.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 6), 0, 0));
        this.add((Component)this._name, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._desc = new JTextArea();
        this._desc.setRows(3);
        this._desc.setLineWrap(true);
        this._desc.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this._desc, 22, 31);
        this.add((Component)jLabel2, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 0, 0, 6), 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(1, n, 2, 1, 0.5, 0.5, 23, 1, new Insets(10, 0, 0, 0), 0, 0));
        this._btnOpenFile = new JButton();
        this._btnOpenFile.addActionListener(this);
        this._btnOpenFile.setIcon(OracleIcons.getIcon((String)"open.png"));
        this._btnOpenFile.setToolTipText(ReportArb.getString("OPEN_FILE"));
        this._btnClearAll = new JButton();
        this._btnClearAll.addActionListener(this);
        this._btnClearAll.setIcon(OracleIcons.getIcon((String)"clear.png"));
        this._btnClearAll.setToolTipText(ReportArb.getString("CLEAR_ALL"));
        this._style = new JComboBox();
        ArrayList arrayList = DisplayRegistry.getNLSStyles();
        for (Object object2 : arrayList) {
            this._style.addItem(object2);
        }
        this._style.setSelectedItem(DisplayConstants.REPORT_STYLES.TABLE.getNLSName());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 6), 0, 0));
        jPanel.add((Component)this._style, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 24, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)jLabel4, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 23, 0, new Insets(3, 0, 0, 0), 0, 0));
        this._toolbar = new Toolbar();
        this._toolbar.setFloatable(false);
        this._toolbar.add((Component)this._btnOpenFile);
        this._toolbar.addSeparator();
        this._toolbar.add((Component)this._btnClearAll);
        object2 = new JPanel(new GridBagLayout());
        ((JComponent)object2).setBorder(BorderFactory.createEtchedBorder());
        ((Container)object2).add((Component)this._toolbar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        ((Container)object2).add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)object2, new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 23, 2, new Insets(10, 0, 0, 0), 0, 0));
        this._sql = EditorFactory.createIdeEditorPane();
        this._sql.setDocument((Document)new BasicDocument("foo.plsql"));
        this._sql.setText("");
        this._sql.setEditable(true);
        JScrollPane jScrollPane2 = new JScrollPane((Component)this._sql, 22, 32);
        jScrollPane2.setPreferredSize(this._sql.getPreferredSize());
        jScrollPane2.setSize(jScrollPane2.getPreferredSize());
        this.add((Component)jScrollPane2, new GridBagConstraints(0, ++n, 2, 4, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 150));
    }

    @Override
    public String getName() {
        return this._name.getText();
    }

    public void setInfo(String string, String string2, String string3) {
        this._name.setText(string);
        this._sql.setText(string2);
        if (string3 == null || string3.isEmpty()) {
            this._style.setSelectedItem(DisplayConstants.REPORT_STYLES.TABLE.getNLSName());
        } else {
            String string4 = DisplayRegistry.getNLSStyle((String)string3);
            this._style.setSelectedItem(string4);
        }
    }

    public String getSql() {
        String string = this._sql.getText().trim();
        if ((string.toLowerCase().indexOf("select") == 0 || string.toLowerCase().indexOf("with") == 0) && string.indexOf(";") == string.length() - 1) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String getStyle() {
        int n = this._style.getSelectedIndex();
        return DisplayRegistry.getStyleType((int)n);
    }

    public String getDescription() {
        return this._desc.getText().trim();
    }

    public String getNLSStyle() {
        return (String)this._style.getSelectedItem();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._btnOpenFile) {
            this.getFileName(this._sql);
        } else if (actionEvent.getSource() == this._btnClearAll) {
            this._sql.setText("");
        }
    }

    private void getFileName(BasicEditorPane basicEditorPane) {
        Object object;
        Object object2;
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.setDefaultTitle(ReportArb.getString("CHOOSE_FILE"));
        uRLFileChooser.clearChooseableURLFilters();
        DefaultURLFilter defaultURLFilter = new DefaultURLFilter(ReportArb.getString("FILE_FILTER_ALL"), "");
        uRLFileChooser.setURLFilter((URLFilter)defaultURLFilter);
        uRLFileChooser.setURLFilter((URLFilter)new DefaultURLFilter(ReportArb.getString("FILE_FILTER_TEXT_NAME"), ReportArb.getString("FILE_FILTER_TEXT_EXT")));
        uRLFileChooser.setURLFilter((URLFilter)new DefaultURLFilter(ReportArb.getString("FILE_FILTER_SQL_NAME"), ReportArb.getString("FILE_FILTER_SQL_EXT")));
        if (_lastUrl == null) {
            try {
                object2 = System.getProperty("user.home");
                object = new File((String)object2);
                uRLFileChooser.setSelectedURL(((File)object).toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            uRLFileChooser.setSelectedURL(_lastUrl);
        }
        if (uRLFileChooser.showOpenDialog((Component)this) == 0 && ((File)(object2 = new File((_lastUrl = uRLFileChooser.getSelectedURL()).getFile()))).isFile()) {
            try {
                object = new FileInputStream((File)object2);
                int n = ((FileInputStream)object).available();
                byte[] byArray = new byte[n];
                ((FileInputStream)object).read(byArray);
                String string = new String(byArray);
                basicEditorPane.setText(string);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }
}

