/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.report.ui.BindNode;
import oracle.dbtools.raptor.report.ui.ChildReportsNode;
import oracle.dbtools.raptor.report.ui.DisplayModelContext;
import oracle.dbtools.raptor.report.ui.DrillDownNode;
import oracle.dbtools.raptor.report.ui.PropertyNode;
import oracle.dbtools.raptor.report.ui.ReportArb;
import oracle.dbtools.raptor.report.ui.ReportNamePanel;
import oracle.dbtools.raptor.report.ui.ReportTreeContext;
import oracle.dbtools.raptor.report.ui.ReportTreeNode;
import oracle.dbtools.raptor.report.ui.SQLNode;

public class ChildNode
extends ReportTreeNode
implements DisplayModelContext {
    public static final String LABEL = ReportArb.getString("CHILD_REPORT_NODE");
    private ReportNamePanel panel;
    private SQLNode sqlNode;
    private PropertyNode propertyNode;

    public ChildNode(ReportTreeContext reportTreeContext) {
        super(reportTreeContext);
        this.sqlNode = new SQLNode(reportTreeContext, null);
        this.sqlNode.insertAtTail(this);
        this.sqlNode.setVisible(true);
        this.propertyNode = new PropertyNode(reportTreeContext);
        this.propertyNode.insertAtTail(this);
        this.propertyNode.setVisible(true);
        reportTreeContext.setSQLNode(this.sqlNode);
        this.context().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("NAME")) {
                    ChildNode.this.refreshJNode();
                    ChildNode.this.parentNode(ChildReportsNode.class).refreshChildPanel();
                }
            }
        });
    }

    @Override
    public String toString() {
        String string = this.name();
        return string != null && !string.equals("") ? string : LABEL;
    }

    @Override
    public String typeLabel() {
        return LABEL;
    }

    @Override
    public ReportNamePanel panel() {
        if (this.panel == null) {
            this.panel = new ReportNamePanel(this.context(), new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("NAME")) {
                        ChildNode.this.context().setName((String)propertyChangeEvent.getNewValue());
                    } else if (propertyChangeEvent.getPropertyName().equals("STYLE")) {
                        ChildNode.this.context().setStyle(ChildNode.this.panel.getStyle());
                    }
                }
            });
            DisplayModel displayModel = this.context().model();
            if (displayModel != null) {
                this.panel.setInfo(displayModel.getName(), displayModel.getDescription(), displayModel.getToolTip(), displayModel.getStyle());
            } else {
                this.panel.setInfo(this.context().name(), null, null, null);
            }
        }
        return this.panel;
    }

    @Override
    public SQLNode sqlNode() {
        return this.sqlNode;
    }

    @Override
    public ChildReportsNode childReportsNode() {
        return null;
    }

    @Override
    public BindNode bindNode() {
        return null;
    }

    @Override
    public DrillDownNode drillDownNode() {
        return null;
    }

    @Override
    public PropertyNode propertyNode() {
        return this.propertyNode;
    }
}

