/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.xml;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.xml.Resetable;

public final class NewlineNormalizer
extends Writer
implements Resetable {
    private final Writer target;
    private static final Log LOG = Log.get(NewlineNormalizer.class);
    private static final char SLASH_R = '\r';

    private NewlineNormalizer(Writer target) {
        this.target = target;
    }

    @Override
    public void close() throws IOException {
        this.target.close();
    }

    @Override
    public void flush() throws IOException {
        this.target.flush();
    }

    @Override
    public void reset() {
        if (this.target instanceof Resetable) {
            ((Resetable)((Object)this.target)).reset();
        }
    }

    public String toString() {
        try {
            this.flush();
        }
        catch (IOException e) {
            LOG.fine(e);
        }
        return this.target.toString();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int end = off + len;
        int start = off;
        int slashR = NewlineNormalizer.indexOf(cbuf, 13, start);
        while (slashR != -1 && start < end) {
            this.target.write(cbuf, start, slashR - start);
            start = slashR + 1;
            if (start >= end) continue;
            slashR = NewlineNormalizer.indexOf(cbuf, 13, start);
        }
        if (start < end) {
            this.target.write(cbuf, start, end - start);
        }
    }

    @Override
    public void write(int c) throws IOException {
        boolean suppress;
        boolean bl = suppress = 13 == c;
        if (!suppress) {
            this.target.write(c);
        }
    }

    public static StreamResult normalize(StreamResult target) {
        Writer w = target.getWriter();
        if (w == null) {
            w = new OutputStreamWriter(target.getOutputStream());
        }
        StreamResult result = new StreamResult(NewlineNormalizer.normalize(w));
        return result;
    }

    public static Writer normalize(Writer target) {
        return new NewlineNormalizer(target);
    }

    private static int indexOf(char[] value, int ch, int fromIndex) {
        int i;
        int max = value.length;
        char[] v = value;
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= value.length) {
            return -1;
        }
        if (ch < 65536) {
            for (i = fromIndex; i < max; ++i) {
                if (v[i] != ch) continue;
                return i;
            }
            return -1;
        }
        if (ch <= 0x10FFFF) {
            char[] surrogates = Character.toChars(ch);
            while (i < max) {
                if (v[i] == surrogates[0]) {
                    if (i + 1 == max) break;
                    if (v[i + 1] == surrogates[1]) {
                        return i;
                    }
                }
                ++i;
            }
        }
        return -1;
    }
}

