/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.x3p.html;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import javax.xml.namespace.QName;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.util.AbstractIterator;
import oracle.dbtools.common.util.ChunkedInputStream;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.x3p.X3PAttribute;
import oracle.dbtools.common.x3p.X3PAttributes;
import oracle.dbtools.common.x3p.X3PHandler;
import oracle.dbtools.common.x3p.X3PReader;

public class XHTML2HTML
implements X3PHandler {
    private final List<String> COMPACT_BOOLEAN = Arrays.asList("async", "compact", "nowrap", "ismap", "declare", "noshade", "checked", "disabled", "readonly", "multiple", "selected", "noresize", "defer", "itemscope", "scoped", "reversed", "pubdate", "seamless", "loop", "autoplay", "controls", "required", "autofocus", "novalidate", "formnovalidate", "open", "hidden");
    private final Stack<Boolean> context = new Stack();
    private final List<String> NO_CLOSE_TAG = Arrays.asList("area", "base", "basefont", "br", "col", "frame", "hr", "img", "input", "isindex", "link", "meta", "param");
    private final Writer writer;
    private static final String XHTML_NS = "http://www.w3.org/1999/xhtml";

    private XHTML2HTML(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.isHtml()) {
            try {
                this.writer.write(ch, start, length);
            }
            catch (IOException e) {
                throw UnrecoverableException.unrecoverable(e);
            }
        }
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void endElement(QName name) {
        String tag = name.getLocalPart();
        if (this.isHtml() && this.requiresCloseTag(tag)) {
            try {
                this.writer.append("</");
                this.writer.append(tag);
                this.writer.append(">");
            }
            catch (IOException e) {
                throw UnrecoverableException.unrecoverable(e);
            }
        }
        this.context.pop();
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }

    @Override
    public void processingInstruction(String target, String data) {
    }

    @Override
    public void skippedEntity(String name) {
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void startElement(QName name, X3PAttributes atts) {
        if (this.isHtml(name)) {
            this.context.push(true);
            try {
                this.writer.append("<");
                this.writer.append(name.getLocalPart());
                for (X3PAttribute att : atts) {
                    if (!att.getName().getNamespaceURI().isEmpty()) continue;
                    this.writer.append(" ");
                    String key = att.getName().getLocalPart();
                    String value = att.getValue();
                    if (this.compactBoolean(key)) {
                        this.writer.append(key);
                        continue;
                    }
                    this.writer.append(key);
                    this.writer.append("=\"");
                    this.writer.append(value);
                    this.writer.append("\"");
                }
                this.writer.append(">");
            }
            catch (IOException e) {
                throw UnrecoverableException.unrecoverable(e);
            }
        } else {
            this.context.push(false);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
    }

    private boolean compactBoolean(String attributeName) {
        return this.COMPACT_BOOLEAN.contains(attributeName);
    }

    private boolean isHtml() {
        return this.context.peek();
    }

    private boolean isHtml(QName name) {
        return XHTML_NS.equals(name.getNamespaceURI()) || name.getNamespaceURI().isEmpty();
    }

    private boolean requiresCloseTag(String localPart) {
        return !this.NO_CLOSE_TAG.contains(localPart);
    }

    public static InputStream htmlStream(X3PReader xhtmlStream) {
        return new ChunkedInputStream(new HTMLChunker(xhtmlStream));
    }

    private static final class HTMLChunker
    extends AbstractIterator<byte[]>
    implements ChunkedInputStream.Chunker {
        private final X3PReader r;
        private final StringWriter text;
        private final XHTML2HTML w;

        HTMLChunker(X3PReader r) {
            this.r = r;
            this.text = new StringWriter();
            this.w = new XHTML2HTML(this.text);
            r.setHandler(this.w);
        }

        @Override
        public void close() throws IOException {
            Closeables.close(this.r);
        }

        @Override
        protected byte[] advance() {
            try {
                byte[] chunk = null;
                boolean empty = true;
                boolean more = true;
                while (empty && more) {
                    more = this.r.next();
                    this.text.flush();
                    chunk = this.text.toString().getBytes(Charset.forName("UTF-8"));
                    this.text.getBuffer().delete(0, this.text.getBuffer().length());
                    empty = chunk.length == 0;
                }
                return chunk;
            }
            catch (IOException e) {
                throw UnrecoverableException.unrecoverable(e);
            }
        }
    }
}

