/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.x3p;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import oracle.dbtools.common.x3p.X3PAttribute;
import oracle.dbtools.common.x3p.X3PAttributes;
import oracle.dbtools.common.x3p.X3PPath;
import oracle.dbtools.common.x3p.X3PReader;
import oracle.dbtools.common.x3p.impl.X3PBuilderImpl;

public abstract class X3PBuilder
implements Iterable<X3PReader> {
    protected final boolean emitDocumentEvents;
    public static final X3PAttributes EMPTY_ATTRIBUTES = X3PBuilder.attributes().build();
    public static final Iterable<X3PReader> EMPTY_ITERABLE = Collections.emptyList();
    public static final X3PReader EMPTY_READER = X3PBuilder.builder(true).startDocument().endDocument().build();

    protected X3PBuilder(boolean emitDocumentEvents) {
        this.emitDocumentEvents = emitDocumentEvents;
    }

    public abstract X3PBuilder addAttributes(X3PAttributes var1);

    public abstract X3PReader build();

    public abstract X3PBuilder characters(char[] var1, int var2, int var3);

    public X3PBuilder characters(String text) {
        char[] chars = text.toCharArray();
        return this.characters(chars, 0, chars.length);
    }

    public X3PBuilder element(QName name) {
        return this.element(name, null);
    }

    public X3PBuilder element(QName name, X3PAttributes attrs) {
        return this.element(name, attrs, null);
    }

    public X3PBuilder element(QName name, X3PAttributes attrs, String text) {
        this.startElement(name, attrs);
        if (text != null) {
            this.characters(text);
        }
        this.endElement(name);
        return this;
    }

    public abstract X3PBuilder endDocument();

    public abstract X3PBuilder endElement(QName var1);

    public abstract X3PBuilder endPrefixMapping(String var1);

    @Override
    public Iterator<X3PReader> iterator() {
        return new ReaderIterator();
    }

    public abstract X3PBuilder processingInstruction(String var1, String var2);

    public abstract X3PBuilder skippedEntity(String var1);

    public abstract X3PBuilder startDocument();

    public X3PBuilder startElement(QName name) {
        return this.startElement(name, null);
    }

    public abstract X3PBuilder startElement(QName var1, X3PAttributes var2);

    public abstract X3PBuilder startPrefixMapping(String var1, String var2);

    public static AttributeBuilder attributes() {
        return new AttributeBuilder();
    }

    public static X3PAttributes attributes(String ... attributePairs) {
        return X3PBuilderImpl.attributes(attributePairs);
    }

    public static X3PBuilder builder() {
        return X3PBuilder.builder(false);
    }

    public static X3PBuilder builder(boolean emitDocumentEvents) {
        return X3PBuilderImpl.builder(emitDocumentEvents);
    }

    public static boolean isNullOrEmpty(X3PAttributes atts) {
        return atts == null || atts.size() == 0;
    }

    public static X3PAttributes merge(X3PAttributes existing, X3PAttributes updated) {
        if (existing == null) {
            return updated;
        }
        if (updated == null) {
            return existing;
        }
        ArrayList<QName> newKeys = new ArrayList<QName>(updated.size());
        for (X3PAttribute a : updated) {
            newKeys.add(a.getName());
        }
        AttributeBuilder b = X3PBuilder.attributes();
        for (X3PAttribute a : existing) {
            QName name = a.getName();
            String update = updated.get(name);
            if (update == null) {
                b.attribute(name, existing.get(name));
                continue;
            }
            b.attribute(name, updated.get(name));
            newKeys.remove(name);
        }
        for (QName name : newKeys) {
            b.attribute(name, updated.get(name));
        }
        return b.build();
    }

    public static QName normalizePrefix(X3PPath matched, QName name) {
        for (X3PPath current = matched; current != null; current = current.parent()) {
            if (!current.lastSegment().getNamespaceURI().equals(name.getNamespaceURI())) continue;
            return new QName(name.getNamespaceURI(), name.getLocalPart(), current.lastSegment().getPrefix());
        }
        return name;
    }

    private final class ReaderIterator
    implements Iterator<X3PReader> {
        private boolean built = false;

        private ReaderIterator() {
        }

        @Override
        public boolean hasNext() {
            return !this.built;
        }

        @Override
        public X3PReader next() {
            X3PReader r = X3PBuilder.this.build();
            this.built = true;
            return r;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class AttributeBuilder {
        private final List<X3PAttribute> attributes = new ArrayList<X3PAttribute>();

        public AttributeBuilder attribute(QName name, String value) {
            if (name != null && value != null) {
                this.attributes.add(X3PBuilderImpl.attribute(name, value));
            }
            return this;
        }

        public AttributeBuilder attribute(String name, String value) {
            return this.attribute(new QName(name), value);
        }

        public X3PAttributes build() {
            return X3PBuilderImpl.attributes(this.attributes);
        }

        public String toString() {
            return this.attributes.toString();
        }
    }
}

