/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.dbtools.common.util.Maps;
import oracle.dbtools.common.util.Regex;

public class Template {
    private final List<String> parameters;
    private final String template;
    private static final Pattern PARAM_NAME = Pattern.compile("\\{(\\p{Alpha}[\\p{Alnum}_\\-\\.]*)\\}");

    public Template(String template) {
        this.template = template;
        this.parameters = Collections.unmodifiableList(this.getParameters(template));
    }

    public boolean containsParameter(String name) {
        return this.parameters.contains(name);
    }

    public String encode(Map<String, String> values) {
        String text = this.template;
        if (!this.parameters.isEmpty() && !values.isEmpty()) {
            for (String parameter : values.keySet()) {
                String value = values.get(parameter);
                text = this.substituteValue(text, parameter, value);
            }
        }
        return text;
    }

    public String encode(String ... values) {
        return this.encode(Maps.toMap(values));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Template other = (Template)obj;
        return !(this.template == null ? other.template != null : !this.template.equals(other.template));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.template == null ? 0 : this.template.hashCode());
        return result;
    }

    public List<String> parameters() {
        return this.parameters;
    }

    public String toString() {
        return this.template;
    }

    protected List<String> getParameters(String template) {
        return Regex.getMatches(PARAM_NAME, template);
    }

    protected final String parameter(int i) {
        return this.parameters.get(i);
    }

    protected String substituteValue(String text, String parameter, String value) {
        if (value == null) {
            return text;
        }
        return text.replace("{" + parameter + "}", value);
    }

    protected String template() {
        return this.template;
    }

    public static final boolean equals(Template first, Template second) {
        return first.equals(second);
    }

    public static final String encode(CharSequence template, Map<String, String> values) {
        return new Template(template.toString()).encode(values);
    }
}

