/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

public class SetOnce<T> {
    private boolean set = false;
    private T value;

    public T get() {
        if (!this.set) {
            throw new IllegalStateException("value is not yet set");
        }
        return this.value;
    }

    public void set(T value) {
        if (this.set) {
            throw new IllegalStateException("value cannot be set more than once");
        }
        this.value = value;
        this.set = true;
    }

    public String toString() {
        return this.value == null ? "null" : this.value.toString();
    }
}

