/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.common.util.Template;

public class MatchingTemplate
extends Template {
    private Pattern pattern;
    private static final String[] ESCAPED_META_CHARS = new String[]{"\\<", "\\(", "\\[", "\\{", "\\\\", "\\^", "\\-", "\\=", "\\$", "\\!", "\\|", "\\]", "\\}", "\\)", "\\?", "\\*", "\\+", "\\.", "\\>"};
    private static final int MAX_PARAMETER_NAME = 100;
    private static final int MAX_TEMPLATE = 2000;
    private static final char[] META_CHARS = "<([{\\^-=$!|]})?*+.>".toCharArray();

    public MatchingTemplate(String template) {
        super(template);
    }

    public Map<String, String> decode(String text) {
        Matcher m;
        if (null == text) {
            throw new NullPointerException("text cannot be null");
        }
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        if (this.hasParameters() && (m = this.matcher(text)).matches()) {
            for (int i = 0; i < m.groupCount(); ++i) {
                String match = m.group(i + 1);
                values.put(this.parameter(i), match);
            }
        }
        return values;
    }

    public boolean matches(String text) {
        if (this.hasParameters()) {
            Matcher m = this.matcher(text);
            return m.matches();
        }
        return this.template().equals(text);
    }

    @Override
    protected List<String> getParameters(String template) {
        ArrayList<String> parameters = new ArrayList<String>();
        if (template.length() <= 2000) {
            StringBuilder parameter = null;
            StringBuilder escaped = new StringBuilder(template.length() + 10);
            for (int i = 0; i < template.length(); ++i) {
                char c = template.charAt(i);
                if (this.isParameterOpen(c) && parameter == null) {
                    parameter = new StringBuilder();
                    continue;
                }
                if (parameter == null) {
                    this.escapeMetaCharacters(escaped, c);
                    continue;
                }
                if (this.isParameterClose(c)) {
                    if (parameter.length() <= 100) {
                        parameters.add(parameter.toString());
                        escaped.append("(.+?)");
                    } else {
                        this.notLegalParameter(escaped, parameter);
                    }
                    parameter = null;
                    continue;
                }
                parameter.append(c);
                if (this.legalParameterCharacter(parameter.length() - 1, c)) continue;
                this.notLegalParameter(escaped, parameter);
                parameter = null;
            }
            if (parameter != null) {
                this.notLegalParameter(escaped, parameter);
            }
            if (!parameters.isEmpty()) {
                escaped.append("$");
                escaped.insert(0, "^");
                this.pattern = Pattern.compile(escaped.toString());
            }
        }
        return parameters;
    }

    private String escapeMetaCharacters(int c) {
        for (int i = 0; i < META_CHARS.length; ++i) {
            if (META_CHARS[i] != c) continue;
            return ESCAPED_META_CHARS[i];
        }
        return null;
    }

    private void escapeMetaCharacters(StringBuilder escaped, int c) {
        String metacharacter = this.escapeMetaCharacters(c);
        if (metacharacter == null) {
            escaped.append((char)c);
        } else {
            escaped.append(metacharacter);
        }
    }

    private boolean hasParameters() {
        return this.pattern != null;
    }

    private boolean isParameterClose(int c) {
        return 125 == c;
    }

    private boolean isParameterOpen(int c) {
        return 123 == c;
    }

    private boolean legalParameterCharacter(int parameterNameOffset, int c) {
        if (parameterNameOffset == 0) {
            return Character.isLetter(c);
        }
        return 95 == c || 45 == c || 46 == c || Character.isLetter(c) || Character.isDigit(c);
    }

    private Matcher matcher(String text) {
        return this.pattern.matcher(text);
    }

    private void notLegalParameter(StringBuilder escaped, StringBuilder parameter) {
        String notReallyParameter = parameter.toString();
        escaped.append("\\{");
        for (int j = 0; j < notReallyParameter.length(); ++j) {
            char p = notReallyParameter.charAt(j);
            this.escapeMetaCharacters(escaped, p);
        }
    }
}

