/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.plugin.api.di.annotations.Provides;
import oracle.dbtools.plugin.api.io.IOStreams;

@Provides
public class IOStreamsProvider
implements IOStreams {
    private static final int BUFFER_SIZE = 65536;
    private static final EmptyStream EMPTY_STREAM = new EmptyStream();
    private static final String UTF_8 = Text.defaultEncoding();

    public byte[] asByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ReadableByteChannel source = Channels.newChannel(is);
        WritableByteChannel destination = Channels.newChannel(os);
        this.copy(source, destination);
        os.close();
        return os.toByteArray();
    }

    public InputStream asInputStream(byte[] bytes) {
        return new ByteArrayInputStream(bytes);
    }

    public InputStream asInputStream(CharSequence text) throws IOException {
        if (null == text) {
            return EMPTY_STREAM;
        }
        return this.asInputStream(text.toString().getBytes(UTF_8));
    }

    public String asString(InputStream is) throws IOException {
        byte[] bytes = this.asByteArray(is);
        return Text.toString(bytes);
    }

    public String asString(Readable r) throws IOException {
        StringBuilder b = new StringBuilder();
        this.copy(r, b);
        return b.toString();
    }

    public long copy(InputStream is, OutputStream os) throws IOException {
        if (is != null && os != null) {
            ReadableByteChannel source = Channels.newChannel(is);
            WritableByteChannel destination = Channels.newChannel(os);
            return this.copy(source, destination);
        }
        return -1L;
    }

    public long copy(Readable source, Appendable destination) throws IOException {
        long length = 0L;
        CharBuffer buffer = CharBuffer.allocate(65536);
        while (source.read(buffer) != -1) {
            buffer.flip();
            destination.append(buffer, 0, buffer.limit());
            length += (long)buffer.limit();
            buffer.clear();
        }
        return length;
    }

    public long copy(ReadableByteChannel source, WritableByteChannel destination) throws IOException {
        long length = 0L;
        ByteBuffer buffer = ByteBuffer.allocate(65536);
        while (source.read(buffer) != -1) {
            buffer.flip();
            while (buffer.hasRemaining()) {
                length += (long)destination.write(buffer);
            }
            buffer.clear();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            destination.write(buffer);
        }
        return length;
    }

    public InputStream emptyStream() {
        return EMPTY_STREAM;
    }

    public boolean isEmptyStream(InputStream stream) {
        return EMPTY_STREAM == stream;
    }

    public InputStream uncloseable(InputStream in) {
        return new IgnoreClose(in);
    }

    private static final class IgnoreClose
    extends FilterInputStream {
        public IgnoreClose(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static final class EmptyStream
    extends InputStream {
        private EmptyStream() {
        }

        @Override
        public int read() throws IOException {
            return -1;
        }
    }
}

