/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import oracle.dbtools.common.util.AbstractIterator;

public abstract class Collections {
    public static <E, C extends Collection<E>> C clone(C collection) {
        try {
            Method m = collection.getClass().getMethod("clone", new Class[0]);
            if (Modifier.isPublic(m.getModifiers())) {
                return (C)((Collection)m.invoke(collection, new Object[0]));
            }
            throw new IllegalStateException(collection.getClass() + " is not cloneable");
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(collection.getClass() + " is not cloneable", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Set<T> removeAll(Set<T> items, Iterator<T> toRemove) {
        while (toRemove.hasNext()) {
            items.remove(toRemove.next());
        }
        return items;
    }

    public static <T> Iterator<T> reverseIterator(List<T> items) {
        if (items == null) {
            return null;
        }
        return new ReverseListIterator(items);
    }

    private static final class ReverseListIterator<T>
    extends AbstractIterator<T> {
        private final ListIterator<T> items;

        private ReverseListIterator(List<T> items) {
            this.items = items.listIterator(items.size());
        }

        public String toString() {
            return this.items.toString();
        }

        @Override
        protected T advance() {
            if (this.items.hasPrevious()) {
                return this.items.previous();
            }
            return null;
        }
    }
}

