/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.uri;

import java.net.URI;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.common.x3p.DirectoryTraversals;

public class URISandbox
implements Comparable<URISandbox> {
    private final URI root;

    private URISandbox(URI root) {
        this.root = root.normalize();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        URISandbox other = (URISandbox)obj;
        return !(this.root == null ? other.root != null : !this.root.toString().equals(other.toString()));
    }

    public int hashCode() {
        return this.root.hashCode();
    }

    public String toString() {
        return this.root.toString();
    }

    public URI uri(String path) {
        URI uri = null;
        if (path != null && DirectoryTraversals.validatePath(path)) {
            URI candidate = URIs.resolve(this.root, path);
            if (URIs.within(this.root, candidate = candidate.normalize())) {
                uri = candidate;
            }
        }
        return uri;
    }

    public static URISandbox sandbox(URI root) {
        return new URISandbox(root);
    }

    @Override
    public int compareTo(URISandbox o) {
        return this.root.toASCIIString().compareTo(o.root.toASCIIString());
    }
}

