/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.uri;

import java.net.URI;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import oracle.dbtools.common.uri.ContextPath;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.common.util.URIs;

public class ContextPathImpl
implements ContextPath {
    private final String path;
    private static final String PATH_SEPARATOR = "/";
    private static final String ROOT_CONTEXT = "";

    public ContextPathImpl(String path) {
        this.path = this.normalize(path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContextPathImpl)) {
            return false;
        }
        ContextPathImpl other = (ContextPathImpl)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String path(URI uri) {
        String folder = this.path + PATH_SEPARATOR;
        String path = uri.getPath();
        if (path == null) {
            return null;
        }
        String relative = URIs.relativeTo(folder, path);
        return relative;
    }

    public String toString() {
        return this.path;
    }

    @Override
    public URI uri(URI base) {
        URI uri = URIs.resolve(base, this.path + PATH_SEPARATOR);
        return uri;
    }

    private String normalize(String path) {
        Objects.requireNonNull(path);
        if (path.isEmpty() || path.equals(PATH_SEPARATOR)) {
            return ROOT_CONTEXT;
        }
        String trimmed = Text.trim(path, '/');
        if (trimmed.isEmpty()) {
            return ROOT_CONTEXT;
        }
        StringBuilder b = new StringBuilder(path.length() + 2);
        b.append('/');
        b.append(trimmed);
        return b.toString();
    }

    @Override
    public boolean matches(HttpServletRequest request) {
        String requestUri = request.getRequestURI();
        return this.matches(requestUri);
    }

    @Override
    public boolean matches(String requestUrl) {
        if (ROOT_CONTEXT.equals(this.path)) {
            return true;
        }
        return requestUrl.startsWith(this.path);
    }
}

