/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.ucp;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import oracle.dbtools.common.concurrent.RetryStrategy;
import oracle.dbtools.common.logging.GlobalLog;
import oracle.dbtools.common.ucp.LabelingCallback;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.SortedProperties;
import oracle.dbtools.plugin.api.di.annotations.Provides;
import oracle.dbtools.plugin.api.logging.Log;
import oracle.jdbc.OracleConnection;
import oracle.ucp.ConnectionLabelingCallback;
import oracle.ucp.jdbc.LabelableConnection;
import oracle.ucp.jdbc.ValidConnection;

@Provides
public class Connections {
    private final Log log;
    static final String CONTAINER_LABEL = "oracle.dbtools.jdbc.label.container";
    static final String SCHEMA_LABEL = "oracle.dbtools.jdbc.label.schema";
    private static final String CDB_ROOT = "CDB$ROOT";
    private static final Connections INSTANCE = new Connections(GlobalLog.getInstance());
    private static final String SET_CONTAINER = "alter session set container = \"{0}\"";

    @Inject
    public Connections(Log log) {
        this.log = log;
    }

    public ConnectionLabelingCallback callback(RetryStrategy retries, Set<String> schemaBlacklist) {
        return new LabelingCallback(this.log, this, retries, schemaBlacklist);
    }

    public void close(Connection conn) {
        block8: {
            Objects.requireNonNull(conn);
            try {
                String container;
                if (this.isClosed(conn)) break block8;
                boolean switchToCDBRoot = true;
                if (this.isProxied(conn) && !this.closeProxySession(conn)) {
                    switchToCDBRoot = false;
                    this.markInvalid(conn);
                }
                if (switchToCDBRoot && (container = this.container(conn)) != null) {
                    try {
                        this.setContainer(conn, CDB_ROOT);
                    }
                    catch (SQLException e) {
                        this.markInvalid(conn);
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    this.log.fine((Throwable)e);
                }
            }
            catch (RuntimeException e) {
                this.log.fine((Throwable)e);
                this.evict(conn);
            }
        }
    }

    public Properties label(String container, String schema) {
        SortedProperties label = new SortedProperties();
        if (container != null) {
            ((Properties)label).put(CONTAINER_LABEL, container);
        }
        if (schema != null) {
            ((Properties)label).put(SCHEMA_LABEL, schema);
        }
        return label;
    }

    void evict(Connection conn) {
        try {
            this.markInvalid(conn);
            conn.close();
        }
        catch (SQLException e) {
            this.log.fine((Throwable)e);
        }
    }

    boolean isProxied(Connection conn) {
        if (conn instanceof OracleConnection) {
            return ((OracleConnection)conn).isProxySession();
        }
        return false;
    }

    void markInvalid(Connection conn) {
        Objects.requireNonNull(conn);
        if (conn instanceof ValidConnection) {
            try {
                ((ValidConnection)conn).setInvalid();
            }
            catch (SQLException e) {
                this.log.fine((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setContainer(Connection conn, String container) throws SQLException {
        if (conn instanceof OracleConnection && container != null) {
            PreparedStatement stmt = null;
            try {
                String text = MessageFormat.format(SET_CONTAINER, container);
                stmt = conn.prepareStatement(text);
                stmt.execute();
                if (CDB_ROOT.equalsIgnoreCase(container)) {
                    ((LabelableConnection)conn).removeConnectionLabel(CONTAINER_LABEL);
                } else {
                    ((LabelableConnection)conn).applyConnectionLabel(CONTAINER_LABEL, container);
                }
            }
            finally {
                Closeables.close(stmt);
            }
        }
    }

    String url(Connection conn) {
        String url = "unknown";
        if (conn != null) {
            try {
                url = conn.getMetaData().getURL();
            }
            catch (SQLException e) {
                url = "unknown";
            }
        }
        return url;
    }

    private boolean closeProxySession(Connection conn) {
        try {
            if (conn instanceof OracleConnection) {
                ((OracleConnection)conn).close(1);
                if (conn instanceof LabelableConnection) {
                    ((LabelableConnection)conn).removeConnectionLabel(SCHEMA_LABEL);
                }
                return true;
            }
        }
        catch (SQLException e) {
            this.log.fine((Throwable)e);
        }
        return false;
    }

    private String container(Connection conn) {
        if (!this.isClosed(conn) && conn instanceof LabelableConnection) {
            try {
                Properties labels = ((LabelableConnection)conn).getConnectionLabels();
                if (labels != null) {
                    String container = labels.getProperty(CONTAINER_LABEL);
                    if (CDB_ROOT.equalsIgnoreCase(container)) {
                        return null;
                    }
                    return container;
                }
            }
            catch (SQLException e) {
                this.log.fine((Throwable)e);
            }
        }
        return null;
    }

    private boolean isClosed(Connection conn) {
        try {
            return conn.isClosed();
        }
        catch (SQLException e) {
            this.log.fine((Throwable)e);
            return false;
        }
    }

    public static Connections getInstance() {
        return INSTANCE;
    }
}

