/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.timing;

import java.util.concurrent.TimeUnit;
import oracle.dbtools.common.timing.Lifetime;
import oracle.dbtools.common.timing.TimingClock;
import oracle.dbtools.common.util.TimeDuration;
import oracle.dbtools.common.util.Timestamps;

public class LifetimeImpl
implements Lifetime {
    private final transient TimingClock clock;
    private volatile long created;
    private final TimeDuration duration;

    public LifetimeImpl(TimingClock clock, TimeDuration duration) {
        this.created = clock.now();
        this.duration = duration;
        this.clock = clock;
    }

    @Override
    public int compareTo(Lifetime o) {
        long diff = this.created() - o.created();
        if (diff < 0L) {
            return -1;
        }
        if (diff == 0L) {
            return this.duration().compareTo(o.duration());
        }
        return 1;
    }

    @Override
    public long created() {
        return this.created;
    }

    @Override
    public TimeDuration duration() {
        return this.duration;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifetimeImpl)) {
            return false;
        }
        LifetimeImpl other = (LifetimeImpl)obj;
        if (this.created != other.created) {
            return false;
        }
        return !(this.duration == null ? other.duration != null : !this.duration.equals(other.duration));
    }

    @Override
    public boolean exceeded() {
        long now = this.clock.now();
        return this.duration.exceeded(this.created, now);
    }

    @Override
    public long expires() {
        long duration = TimeUnit.MILLISECONDS.convert(this.duration.duration(), this.duration.unit());
        long expires = this.created + duration;
        return expires;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.created ^ this.created >>> 32);
        result = 31 * result + (this.duration == null ? 0 : this.duration.hashCode());
        return result;
    }

    @Override
    public void reset() {
        this.created = this.clock.now();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LifetimeImpl [created=");
        builder.append(Timestamps.toString(this.created));
        builder.append(", duration=");
        builder.append(this.duration);
        builder.append("]");
        return builder.toString();
    }
}

