/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.tash;

import oracle.dbtools.common.tash.TashTemplate;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.Lookup;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.util.Text;

class TashToken {
    private final CharSequence nameOrText;
    private final TashTemplate section;
    private final TokenType type;

    TashToken(TokenType type, CharSequence name, TashTemplate section) {
        this.type = type;
        this.nameOrText = name;
        this.section = section;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TashToken other = (TashToken)obj;
        if (this.nameOrText == null ? other.nameOrText != null : !this.nameOrText.equals(other.nameOrText)) {
            return false;
        }
        if (this.section == null ? other.section != null : !this.section.equals(other.section)) {
            return false;
        }
        return this.type == other.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nameOrText == null ? 0 : this.nameOrText.hashCode());
        result = 31 * result + (this.section == null ? 0 : this.section.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        switch (this.type) {
            case COMMENT: {
                b.append("{{!");
                b.append(this.nameOrText);
                b.append("}}");
                break;
            }
            case LITERAL: {
                b.append(this.nameOrText);
                break;
            }
            case NEW_LINE: {
                b.append(this.nameOrText);
                break;
            }
            case VARIABLE: {
                b.append("{{");
                b.append(this.nameOrText);
                b.append("}}");
                break;
            }
            case UNESCAPED_VARIABLE: {
                b.append("{{{");
                b.append(this.nameOrText);
                b.append("}}}");
                break;
            }
            case PARTIAL: {
                b.append("{{>");
                b.append(this.nameOrText);
                b.append("}}");
            }
            case SECTION: {
                b.append("{{#");
                b.append(this.nameOrText);
                b.append("}}");
                b.append(this.section);
                b.append("{{/");
                b.append(this.nameOrText);
                b.append("}}");
                break;
            }
            case INVERTED_SECTION: {
                b.append("{{^");
                b.append(this.nameOrText);
                b.append("}}");
                b.append(this.section);
                b.append("{{/");
                b.append(this.nameOrText);
                b.append("}}");
            }
        }
        return b.toString();
    }

    CharSequence name() {
        return this.nameOrText;
    }

    CharSequence render(Lookup<?> values) {
        CharSequence replacement = "";
        if (TokenType.LITERAL == this.type) {
            replacement = this.nameOrText;
        } else {
            Object value = values.get(this.nameOrText.toString());
            switch (this.type) {
                case COMMENT: {
                    break;
                }
                case LITERAL: {
                    throw new IllegalStateException();
                }
                case NEW_LINE: {
                    replacement = this.nameOrText;
                    break;
                }
                case VARIABLE: {
                    if (this.falsey(value)) break;
                    replacement = this.escape(value.toString());
                    break;
                }
                case UNESCAPED_VARIABLE: {
                    if (this.falsey(value)) break;
                    replacement = value.toString();
                    break;
                }
                case PARTIAL: {
                    if (this.section == null) break;
                    replacement = this.render(this.section, values);
                    break;
                }
                case SECTION: {
                    if (this.falsey(value)) break;
                    if (PrimitiveTypes.isPrimitive(value)) {
                        replacement = this.render(this.section, values);
                        break;
                    }
                    replacement = this.render(this.section, value);
                    break;
                }
                case INVERTED_SECTION: {
                    if (!this.falsey(value)) break;
                    replacement = this.section.render(value);
                }
            }
        }
        return replacement;
    }

    private String escape(String text) {
        return Text.escapeHtml(text);
    }

    private boolean falsey(Object value) {
        if (value == null || Boolean.FALSE.equals(value)) {
            return true;
        }
        if (this.isIterable(value)) {
            return NullOrEmpty.nullOrEmpty((Iterable)value);
        }
        return false;
    }

    private boolean isIterable(Object value) {
        return value instanceof Iterable && !(value instanceof AssociativeArray);
    }

    private CharSequence render(TashTemplate template, Object value) {
        String replacement;
        if (this.isIterable(value)) {
            StringBuilder b = new StringBuilder();
            Iterable items = (Iterable)value;
            for (Object item : items) {
                String rendered = template.render(item);
                b.append(rendered);
            }
            replacement = b.toString();
        } else {
            replacement = template.render(value);
        }
        return replacement;
    }

    static enum TokenType {
        COMMENT,
        INVERTED_SECTION,
        LITERAL,
        NEW_LINE,
        PARTIAL,
        SECTION,
        UNESCAPED_VARIABLE,
        VARIABLE;

    }
}

