/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.tash;

import java.util.ArrayList;
import java.util.Map;
import oracle.dbtools.common.immutables.ImmutableMap;
import oracle.dbtools.common.tash.TashParser;
import oracle.dbtools.common.tash.TashTemplate;
import oracle.dbtools.common.tash.TashToken;
import oracle.dbtools.common.util.AssociativeArrays;
import oracle.dbtools.common.util.Lookup;
import oracle.dbtools.common.util.Maps;

class TashTemplateImpl
implements TashTemplate {
    private final String template;
    private final transient Iterable<TashToken> tokens;

    public TashTemplateImpl(String template, Lookup<TashTemplate> partials) {
        this.template = template;
        this.tokens = this.parse(template, partials);
    }

    TashTemplateImpl(String template) {
        this(template, AssociativeArrays.empty());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TashTemplateImpl other = (TashTemplateImpl)obj;
        return !(this.template == null ? other.template != null : !this.template.equals(other.template));
    }

    public int hashCode() {
        return this.template.hashCode();
    }

    @Override
    public String render(ImmutableMap<String, ?> values) {
        return this.render((Lookup<?>)values);
    }

    @Override
    public String render(Lookup<?> values) {
        StringBuilder text = new StringBuilder();
        for (TashToken token : this.tokens) {
            text.append(token.render(values));
        }
        return text.toString();
    }

    @Override
    public String render(Map<String, ?> values) {
        return this.render(AssociativeArrays.fromMap(values));
    }

    @Override
    public String render(Object value) {
        if (value == null) {
            return this.render(AssociativeArrays.empty());
        }
        Lookup<?> values = null;
        values = value instanceof Lookup ? (Lookup<?>)value : this.toLookup(value);
        return this.render(values);
    }

    public String toString() {
        return this.template;
    }

    private Iterable<TashToken> parse(String template, Lookup<TashTemplate> partials) {
        ArrayList<TashToken> tokens = new ArrayList<TashToken>();
        TashParser parser = new TashParser(template, partials);
        while (parser.hasNext()) {
            TashToken token = (TashToken)parser.next();
            tokens.add(token);
        }
        return tokens;
    }

    private Lookup<?> toLookup(Object value) {
        return AssociativeArrays.fromMap(Maps.beanAsMap(value));
    }
}

