/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.reflect;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import javax.annotation.processing.Processor;
import oracle.dbtools.common.reflect.AnnotatedElements;
import oracle.dbtools.common.reflect.AnnotationProcessorRuntime;
import oracle.dbtools.common.reflect.FileResource;
import oracle.dbtools.common.reflect.FileResourceFactory;
import oracle.dbtools.common.service.apt.ConfigProcessor;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.plugin.api.logging.Log;
import oracle.dbtools.plugin.apt.AnnotationProcessor;

public class AnnotationProcessors {
    private final Log log;
    private final Class<? extends Processor>[] processors;

    public AnnotationProcessors(Log log, Class<? extends Processor> ... processors) {
        this.log = log;
        this.processors = processors;
    }

    public void invoke(FileResourceFactory factory, Iterable<String> packageNames, Iterable<String> validRoots) {
        try {
            ClassLoader parent = Thread.currentThread().getContextClassLoader();
            AnnotatedElements annotatedElements = new AnnotatedElements(this.log, parent, packageNames, validRoots);
            this.invoke(factory, parent, annotatedElements);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void invoke(Iterable<String> packageNames, Iterable<String> validRoots) {
        try {
            ClassLoader parent = Thread.currentThread().getContextClassLoader();
            AnnotatedElements annotatedElements = new AnnotatedElements(this.log, parent, packageNames, validRoots);
            File root = Iterables.first(annotatedElements.roots());
            this.invoke((FileResourceFactory)new FileResources(root), parent, annotatedElements);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error invoking annotation processors, roots: " + Iterables.join(validRoots, ", "), t);
        }
    }

    private void invoke(FileResourceFactory factory, ClassLoader parent, AnnotatedElements annotatedElements) throws Exception {
        ArrayList<AnnotatedElement> elements = new ArrayList<AnnotatedElement>();
        for (String annotationType : annotatedElements.annotationTypes()) {
            for (AnnotatedElements.AnnotationSite annotatedElement : annotatedElements.annotatedElements(annotationType)) {
                elements.add(annotatedElement.asAnnotatedElement(parent));
            }
        }
        AnnotationProcessorRuntime runtime = new AnnotationProcessorRuntime(factory, elements, this.processors);
        runtime.call();
    }

    public static void invokeAnnotationProcessors(Log log) {
        AnnotationProcessors aps = new AnnotationProcessors(log, AnnotationProcessor.class, ConfigProcessor.class);
        aps.invoke(Iterables.iterable("oracle.dbtools", "oracle.json.ords"), Iterables.iterable("classes"));
    }

    private static final class FileResources
    implements FileResourceFactory {
        private final File root;

        public FileResources(File root) {
            this.root = root;
        }

        @Override
        public FileResource get(String path) throws IOException {
            File file = Files.file(this.root, path);
            return new Resource(path, file);
        }

        private static final class Resource
        implements FileResource {
            private final File file;
            private final String path;

            public Resource(String path, File file) {
                this.path = path;
                this.file = file;
            }

            @Override
            public boolean delete() throws IOException {
                return this.file.delete();
            }

            @Override
            public boolean exists() {
                return this.file.exists();
            }

            @Override
            public InputStream inputStream() throws IOException {
                return Files.inputStream(this.file);
            }

            @Override
            public long lastModified() {
                return this.file.lastModified();
            }

            @Override
            public OutputStream outputStream() throws IOException {
                return Files.outputStream(this.file);
            }

            @Override
            public String path() {
                return this.path;
            }
        }
    }
}

