/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.immutables.impl;

import java.util.Comparator;
import java.util.Set;
import oracle.dbtools.common.immutables.ImmutableSet;
import oracle.dbtools.common.immutables.impl.CollectionFactory;
import oracle.dbtools.common.immutables.impl.SetImpl;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Ordering;

class SetBuilder<V>
implements ImmutableSet.Builder<V> {
    private Comparator<? super V> comparator;
    private final Set<V> elements;
    private Ordering ordering;

    private SetBuilder(int size, Ordering ordering, Comparator<? super V> comparator) {
        this.elements = CollectionFactory.set(size, Ordering.INSERTION, null);
        this.ordering = ordering;
        this.comparator = comparator;
    }

    @Override
    public SetBuilder<V> add(Iterable<V> values) {
        Iterables.add(this.elements, values);
        return this;
    }

    @Override
    public SetBuilder<V> add(V value) {
        this.elements.add(value);
        return this;
    }

    @Override
    public ImmutableSet<V> build() {
        return SetImpl.newInstance(this.elements, this.ordering, this.comparator);
    }

    @Override
    public SetBuilder<V> clear() {
        this.elements.clear();
        return this;
    }

    @Override
    public SetBuilder<V> comparator(Comparator<? super V> comparator) {
        this.comparator = comparator;
        return this;
    }

    public boolean equals(Object obj) {
        return this.elements.equals(obj);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public SetBuilder<V> ordering(Ordering ordering) {
        this.ordering = ordering;
        return this;
    }

    @Override
    public SetBuilder<V> remove(Iterable<V> values) {
        for (V value : values) {
            this.remove(value);
        }
        return this;
    }

    @Override
    public SetBuilder<V> remove(Object o) {
        this.elements.remove(o);
        return this;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    public String toString() {
        return this.elements.toString();
    }

    static <V> SetBuilder<V> newInstance(int size, Ordering ordering, Comparator<? super V> comparator) {
        size = size == 0 ? 10 : (size *= 2);
        SetBuilder<? super V> builder = new SetBuilder<V>(size, ordering, comparator);
        return builder;
    }
}

