/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.immutables.impl;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.dbtools.common.immutables.ImmutableCollection;
import oracle.dbtools.common.immutables.ImmutableMap;
import oracle.dbtools.common.immutables.ImmutableMultiMap;
import oracle.dbtools.common.immutables.ImmutableSet;
import oracle.dbtools.common.immutables.impl.MultiMapBuilder;
import oracle.dbtools.common.immutables.impl.SetBuilder;
import oracle.dbtools.common.util.KeyedLookup;
import oracle.dbtools.common.util.Ordering;
import oracle.dbtools.plugin.api.collections.MultiMap;

class CaseInsensitiveMultiMap<V>
implements ImmutableMultiMap<String, V> {
    private final ImmutableMultiMap<String, V> caseNormalized;
    private final ImmutableMultiMap<String, V> casePreserved;
    private final ImmutableSet<String> keys;

    private CaseInsensitiveMultiMap(ImmutableMultiMap<String, V> target) {
        LinkedHashMap<String, String> keys = new LinkedHashMap<String, String>(target.size());
        ImmutableMultiMap.Builder casePreserved = target.modify().clear();
        ImmutableMultiMap.Builder normalized = target.modify().ordering(Ordering.INSERTION).clear();
        for (Map.Entry entry : target.entries()) {
            String key = (String)entry.getKey();
            String normalizedKey = CaseInsensitiveMultiMap.normalize(key);
            String existing = (String)keys.get(normalizedKey);
            Object value = entry.getValue();
            if (existing == null) {
                keys.put(normalizedKey, key);
            }
            casePreserved.add(key, value);
            normalized.add(normalizedKey, value);
        }
        this.casePreserved = casePreserved.build();
        this.caseNormalized = normalized.build();
        this.keys = ((SetBuilder)SetBuilder.newInstance(keys.size(), Ordering.INSERTION, null).add((Iterable)keys.values())).build();
    }

    @Override
    public Comparator<? super String> comparator() {
        return this.casePreserved.comparator();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.caseNormalized.containsKey(CaseInsensitiveMultiMap.normalize(key));
    }

    @Override
    public ImmutableCollection<Map.Entry<String, V>> entries() {
        return this.casePreserved.entries();
    }

    public boolean equals(Object obj) {
        return this.casePreserved.equals(obj);
    }

    @Override
    public V get(Object key) {
        return this.caseNormalized.get(CaseInsensitiveMultiMap.normalize(key));
    }

    public int hashCode() {
        return this.casePreserved.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.casePreserved.isEmpty();
    }

    @Override
    public ImmutableSet<String> keySet() {
        return this.keys;
    }

    @Override
    public ImmutableMap<String, Collection<V>> map() {
        return this.casePreserved.map();
    }

    public Builder<V> modify() {
        return new Builder().add(this.casePreserved);
    }

    @Override
    public Ordering ordering() {
        return this.casePreserved.ordering();
    }

    @Override
    public int size() {
        return this.casePreserved.size();
    }

    public String toString() {
        return this.casePreserved.toString();
    }

    @Override
    public ImmutableCollection<V> values(Object key) {
        return this.caseNormalized.values(CaseInsensitiveMultiMap.normalize(key));
    }

    private static String normalize(Object key) {
        return key.toString().toLowerCase();
    }

    static class Builder<V>
    implements ImmutableMultiMap.Builder<String, V> {
        private final ImmutableMultiMap.Builder<String, V> map = MultiMapBuilder.newInstance(0);

        Builder() {
        }

        public Builder<V> add(KeyedLookup<? extends String, ? extends V> m) {
            this.map.add(m);
            return this;
        }

        public Builder<V> add(Map<? extends String, ? extends V> m) {
            this.map.add(m);
            return this;
        }

        public Builder<V> add(MultiMap<? extends String, ? extends V> m) {
            this.map.add(m);
            return this;
        }

        public Builder<V> add(String key, V value) {
            this.map.add(key, value);
            return this;
        }

        @Override
        public ImmutableMultiMap<String, V> build() {
            return new CaseInsensitiveMultiMap(this.map.build());
        }

        public Builder<V> clear() {
            this.map.clear();
            return this;
        }

        @Override
        public Builder<V> comparator(Comparator<? super String> comparator) {
            this.map.comparator((Comparator<String>)comparator);
            return this;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.build().containsKey(key);
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Builder<V> ordering(Ordering ordering) {
            this.map.ordering(ordering);
            return this;
        }

        public Builder<V> remove(Object key) {
            this.map.remove(key);
            return this;
        }

        public Builder<V> remove(Object key, Object value) {
            this.map.remove(key, value);
            return this;
        }

        public Builder<V> set(String key, V value) {
            this.map.set(key, value);
            return this;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        public String toString() {
            return this.build().toString();
        }
    }
}

