/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.identifiers;

import java.math.BigInteger;
import oracle.dbtools.common.identifiers.Identifier;
import oracle.dbtools.common.identifiers.NumericIdentifiers;
import oracle.dbtools.common.util.CharSequenceMixin;

public class PartitionedIdentifier
extends CharSequenceMixin
implements Identifier,
Comparable<PartitionedIdentifier> {
    private final BigInteger id;
    private final BigInteger partitionId;

    public PartitionedIdentifier(Number partitionId, Number id) {
        this.partitionId = PartitionedIdentifier.normalize(partitionId);
        this.id = PartitionedIdentifier.normalize(id);
    }

    @Override
    public int compareTo(PartitionedIdentifier o) {
        int result = this.partitionId.compareTo(o.partitionId);
        if (result == 0) {
            result = this.id.compareTo(o.id);
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PartitionedIdentifier other = (PartitionedIdentifier)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.partitionId == null ? other.partitionId != null : !this.partitionId.equals(other.partitionId));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.partitionId == null ? 0 : this.partitionId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.partitionId);
        builder.append("|");
        builder.append(this.id);
        return builder.toString();
    }

    private static BigInteger normalize(Number value) {
        return NumericIdentifiers.NUMERIC_IDENTIFIER_TYPE.cast(NumericIdentifiers.identifier(value));
    }
}

