/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.di;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import oracle.dbtools.common.di.ConstrainedProvider;
import oracle.dbtools.common.di.DependencyConstraints;
import oracle.dbtools.common.di.ServiceLocator;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.MultiAssociativeArray;
import oracle.dbtools.common.util.MultiAssociativeArrays;
import oracle.dbtools.plugin.api.di.Annotations;
import oracle.dbtools.plugin.api.di.annotations.Priority;

class ExternalProviders
implements ServiceLocator,
Closeable {
    private final MultiAssociativeArray<Class<?>, ConstrainedProvider<?>> providers;
    private static final Priority DEFAULT_PRIORITY = (Priority)Annotations.INSTANCE.literal(Priority.class);

    protected ExternalProviders(MultiAssociativeArray<Class<?>, ConstrainedProvider<?>> providers) {
        this.providers = providers;
    }

    @Override
    public <T> Iterable<T> acquireAll(Class<T> type, DependencyConstraints constraints) {
        return this.acquireAll(type, constraints, false);
    }

    @Override
    public <T> Iterable<T> acquireAll(Class<T> type, DependencyConstraints constraints, boolean ignoreMissingDependencies) {
        ArrayList implementations = new ArrayList();
        Iterable<ConstrainedProvider<T>> providers = this.providers(type);
        for (ConstrainedProvider<T> provider : providers) {
            Iterable<T> matches = provider.get(type, constraints);
            Iterables.add(implementations, matches);
        }
        return implementations;
    }

    public <T> boolean canProvide(Class<T> type, DependencyConstraints constraints) {
        ConstrainedProvider<T> provider;
        boolean provides = false;
        Iterable<ConstrainedProvider<T>> providers = this.providers(type);
        Iterator<ConstrainedProvider<T>> i$ = providers.iterator();
        while (i$.hasNext() && !(provides = (provider = i$.next()).canProvide(type, constraints))) {
        }
        return provides;
    }

    @Override
    public void close() throws IOException {
        for (Class key : this.providers) {
            for (ConstrainedProvider<?> provider : this.providers.values(key)) {
                Closeables.close(provider);
            }
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(super.toString());
        b.append("\n");
        for (Class type : this.providers) {
            Iterable<ConstrainedProvider<?>> provider = this.providers.values(type);
            b.append(type.getName());
            b.append(": ");
            b.append(provider);
            b.append("\n");
        }
        return b.toString();
    }

    private <T> Iterable<ConstrainedProvider<T>> providers(Class<T> type) {
        ArrayList<ConstrainedProvider<T>> providers = new ArrayList<ConstrainedProvider<T>>();
        Iterable<ConstrainedProvider<?>> matches = this.providers.values(type);
        if (null != matches) {
            Iterator<ConstrainedProvider<?>> i$ = matches.iterator();
            while (i$.hasNext()) {
                ConstrainedProvider<?> provider;
                ConstrainedProvider<?> actual = provider = i$.next();
                providers.add(actual);
            }
        }
        Collections.sort(providers, new ProviderComparator());
        return providers;
    }

    static Builder builder() {
        return ExternalProviders.builder(null);
    }

    static Builder builder(ExternalProviders existing) {
        return new Builder(existing);
    }

    private class ProviderComparator<T>
    implements Comparator<ConstrainedProvider<T>> {
        private ProviderComparator() {
        }

        @Override
        public int compare(ConstrainedProvider<T> o1, ConstrainedProvider<T> o2) {
            Priority p1 = this.priority(o1);
            Priority p2 = this.priority(o2);
            int diff = p1.ring() - p2.ring();
            if (diff == 0) {
                diff = p2.value() - p1.value();
            }
            return diff;
        }

        private Priority priority(Class<?> type) {
            Priority priority = type.getAnnotation(Priority.class);
            if (priority == null) {
                priority = DEFAULT_PRIORITY;
            }
            return priority;
        }

        private Priority priority(ConstrainedProvider<T> provider) {
            return this.priority(provider.getClass());
        }
    }

    static class Builder {
        private final MultiAssociativeArrays.Builder<Class<?>, ConstrainedProvider<?>> providers = MultiAssociativeArrays.builder();

        protected Builder(ExternalProviders existing) {
            if (existing != null) {
                this.providers.add(existing.providers);
            }
        }

        Builder add(Class<?> provides, ConstrainedProvider<?> provider) {
            if (!this.providers.contains(provides, provider)) {
                this.providers.add(provides, provider);
            }
            return this;
        }

        Builder add(Class<?> provides, Object impl, DependencyConstraints constraints) {
            if (provides.isInstance(impl)) {
                return this.add(provides, new InstanceProvider(provides, impl, constraints));
            }
            return this;
        }

        Builder remove(Class<?> provides) {
            this.providers.remove(provides);
            return this;
        }

        Builder set(Class<?> provides, ConstrainedProvider<?> provider) {
            this.providers.set(provides, provider);
            return this;
        }

        Builder set(Class<?> provides, Object impl) {
            return this.set(provides, impl, DependencyConstraints.NO_CONSTRAINTS);
        }

        Builder set(Class<?> provides, Object impl, DependencyConstraints constraints) {
            if (provides.isInstance(impl)) {
                return this.set(provides, new InstanceProvider(provides, impl, constraints));
            }
            return this;
        }

        public ExternalProviders build() {
            return new ExternalProviders(this.providers.build());
        }

        private static final class InstanceProvider
        implements ConstrainedProvider<Object> {
            private final DependencyConstraints constraints;
            private final Object impl;
            private final Class<?> provides;

            private InstanceProvider(Class<?> provides, Object impl, DependencyConstraints constraints) {
                this.impl = impl;
                this.constraints = constraints;
                this.provides = provides;
            }

            @Override
            public boolean canProvide(Class<Object> type, DependencyConstraints expected) {
                return this.provides.equals(type) && this.constraints.matches(expected);
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                InstanceProvider other = (InstanceProvider)obj;
                if (this.constraints == null ? other.constraints != null : !this.constraints.equals(other.constraints)) {
                    return false;
                }
                if (this.impl == null ? other.impl != null : !this.impl.equals(other.impl)) {
                    return false;
                }
                return !(this.provides == null ? other.provides != null : !this.provides.equals(other.provides));
            }

            @Override
            public Iterable<Object> get(Class<Object> type, DependencyConstraints expected) {
                if (this.provides.equals(type) && this.constraints.matches(expected)) {
                    return Iterables.iterable(this.impl);
                }
                return null;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.constraints == null ? 0 : this.constraints.hashCode());
                result = 31 * result + (this.impl == null ? 0 : this.impl.hashCode());
                result = 31 * result + (this.provides == null ? 0 : this.provides.hashCode());
                return result;
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append(this.impl);
                builder.append(", ");
                builder.append(this.constraints);
                return builder.toString();
            }
        }
    }
}

