/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.di;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.common.di.Dependency;
import oracle.dbtools.common.di.DependencyConstraints;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.NullOrEmpty;

class DependencyArc {
    private final Dependency dependency;
    private final List<Class<?>> implementations = new ArrayList();

    DependencyArc(Dependency dependency, Class<?> implementation) {
        this.dependency = dependency;
        if (implementation != null) {
            this.implementations.add(implementation);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DependencyArc other = (DependencyArc)obj;
        if (this.dependency == null ? other.dependency != null : !this.dependency.equals(other.dependency)) {
            return false;
        }
        return !(this.implementations == null ? other.implementations != null : !Iterables.equals(this.implementations, other.implementations));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dependency == null ? 0 : this.dependency.hashCode());
        result = 31 * result + (this.implementations == null ? 0 : this.implementations.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DependencyArc [dependency=");
        builder.append(this.dependency);
        builder.append(", implementations=");
        builder.append(this.implementations);
        builder.append("]");
        return builder.toString();
    }

    DependencyArc add(Class<?> implementation) {
        this.implementations.add(implementation);
        return this;
    }

    DependencyConstraints constraints() {
        return this.dependency.constraints();
    }

    Dependency dependency() {
        return this.dependency;
    }

    boolean external() {
        return NullOrEmpty.nullOrEmpty(this.implementations);
    }

    boolean hasMultiple() {
        return Dependency.Kind.USES_MULTIPLE == this.kind();
    }

    Iterable<Class<?>> implementations() {
        return this.implementations;
    }

    boolean isRequired() {
        return !this.dependency.isOptional();
    }

    Dependency.Kind kind() {
        return this.dependency.kind();
    }

    Class<?> type() {
        return this.dependency.type();
    }

    boolean viaProvider() {
        return Dependency.Kind.USES_VIA_PROVIDER == this.kind();
    }
}

