/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.config.file;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.config.AsAssociativeArray;
import oracle.dbtools.common.config.ConfigurationBase;
import oracle.dbtools.common.config.ConfigurationEventListener;
import oracle.dbtools.common.config.Configurations;
import oracle.dbtools.common.config.MutableConfigurations;
import oracle.dbtools.common.config.PropertiesConfiguration;
import oracle.dbtools.common.config.file.ConfigurationFiles;
import oracle.dbtools.common.config.file.ConfigurationFolder;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.AssociativeArrays;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.ConfigFiles;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.common.util.SortedProperties;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.common.util.TransformCache;
import oracle.dbtools.plugin.api.conf.Configuration;
import oracle.dbtools.plugin.api.logging.Log;

class ConfigurationFilesBase
extends AssociativeArrays.Base<String, Configuration>
implements MutableConfigurations {
    private final TransformCache<String, AssociativeArray<String, String>> confs = new TransformCache<String, AssociativeArray<String, String>>(new ReadConfiguration(), false);
    private final Map<String, List<ConfigurationEventListener>> listeners = new WeakHashMap<String, List<ConfigurationEventListener>>();
    private final File location;
    private final Log log;
    static final String CONF_FOLDER = "conf";
    static final String FILE_SUFFIX = ".xml";
    static final FileFilter IS_CONFIGURATION_FILE = new IsConfigurationFile();
    private static final ConfigurationName CONFIGURATION_NAME = new ConfigurationName();

    protected ConfigurationFilesBase(Log log, File location) {
        this.location = location;
        this.log = log;
        this.ensureDefaultsExist("defaults");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(String name, ConfigurationEventListener listener) {
        Map<String, List<ConfigurationEventListener>> map = this.listeners;
        synchronized (map) {
            List<ConfigurationEventListener> listeners = this.listeners.get(name);
            if (listeners == null) {
                listeners = new ArrayList<ConfigurationEventListener>();
                this.listeners.put(name, listeners);
            }
            listeners.add(listener);
            if (this.exists(name)) {
                listener.configurationChanged(name, new ConfigurationFile(name));
            }
        }
    }

    @Override
    public boolean exists(String name) {
        if ("defaults".equals(name)) {
            return this.defaultsLocation(name).exists();
        }
        return Files.file(this.folder(), name.toLowerCase() + FILE_SUFFIX).exists();
    }

    @Override
    public Configuration get(Object key) {
        return this.get(key.toString());
    }

    @Override
    public Configuration get(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        File file = this.file(name);
        if (file.exists()) {
            return new ConfigurationFile(name);
        }
        return null;
    }

    @Override
    public Iterator<String> iterator() {
        File folder = this.folder();
        Iterator<String> defaults = Iterators.iterator("defaults");
        Object[] files = folder.listFiles(IS_CONFIGURATION_FILE);
        if (NullOrEmpty.nullOrEmpty(files)) {
            return defaults;
        }
        Arrays.sort(files);
        Iterator<String> confs = Iterators.transform(Iterators.iterator(files), CONFIGURATION_NAME);
        return Iterators.sequence(Iterators.iterator(defaults, confs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ConfigurationEventListener listener) {
        Map<String, List<ConfigurationEventListener>> map = this.listeners;
        synchronized (map) {
            Collection<List<ConfigurationEventListener>> all = this.listeners.values();
            for (List<ConfigurationEventListener> listeners : all) {
                Iterator<ConfigurationEventListener> iter = listeners.iterator();
                while (iter.hasNext()) {
                    if (listener != iter.next()) continue;
                    iter.remove();
                }
            }
        }
    }

    @Override
    public int size() {
        LinkedHashSet files = new LinkedHashSet();
        File folder = this.folder();
        Iterator<String> defaults = Iterators.iterator("defaults");
        Iterator<String> confs = Iterators.transform(Iterators.iterator(folder.listFiles(IS_CONFIGURATION_FILE)), CONFIGURATION_NAME);
        Iterators.add(files, defaults);
        Iterators.add(files, confs);
        return files.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Configurations newConfigurations) {
        ArrayList<String> changedConfigs = new ArrayList<String>();
        Set<String> removed = this.removed(this, newConfigurations);
        ConfigurationFilesBase configurationFilesBase = this;
        synchronized (configurationFilesBase) {
            boolean defaultsModified;
            AssociativeArray<String, String> existingDefaults = this.values("defaults");
            Configuration newDefaults = newConfigurations.get("defaults");
            if (newDefaults == null) {
                throw new IllegalArgumentException("Must have a default configuration");
            }
            AssociativeArray<String, String> defaults = AsAssociativeArray.asAssociativeArray(newDefaults);
            boolean bl = defaultsModified = !this.equals(existingDefaults, defaults);
            if (defaultsModified) {
                changedConfigs.add("defaults");
                File file = this.file("defaults");
                this.write(file, defaults);
                this.confs.remove("defaults");
            }
            for (String name : newConfigurations) {
                boolean modified;
                if ("defaults".equals(name)) continue;
                Configuration conf = newConfigurations.get(name);
                AssociativeArray<String, String> properties = AsAssociativeArray.asAssociativeArray(conf);
                AssociativeArray<String, String> overriddenProperties = this.difference(defaults, properties);
                AssociativeArray<String, String> existing = this.values(name);
                boolean bl2 = modified = existing == null;
                if (!modified) {
                    AssociativeArray<String, String> existingOverrides = this.difference(existing, overriddenProperties);
                    boolean bl3 = modified = !existingOverrides.isEmpty();
                }
                if (!modified) continue;
                changedConfigs.add(name);
                File file = this.file(name);
                this.write(file, overriddenProperties);
                this.confs.remove(name);
            }
            for (String gone : removed) {
                File file = this.file(gone);
                Files.delete(file);
                this.confs.remove(gone);
            }
        }
        if (this.log.isLoggable(Log.INFO) && !changedConfigs.isEmpty()) {
            this.log.info("Updated configurations: " + Iterables.join(changedConfigs, ", "));
        }
        for (String name : changedConfigs) {
            this.changed(name);
        }
        if (this.log.isLoggable(Log.INFO) && !removed.isEmpty()) {
            this.log.info("Removed configurations: " + Iterables.join(removed, ", "));
        }
        for (String name : removed) {
            List<ConfigurationEventListener> listeners = this.listeners.get(name);
            if (listeners == null) continue;
            for (ConfigurationEventListener listener : listeners) {
                listener.configurationRemoved(name);
            }
        }
    }

    private AssociativeArray<String, String> difference(AssociativeArray<String, String> expected, AssociativeArray<String, String> actual) {
        AssociativeArray<String, String> plainTextActual;
        AssociativeArray<String, String> plainTextExpected = this.plainText(expected);
        AssociativeArray<String, String> plainTextDiff = AssociativeArrays.difference(plainTextExpected, plainTextActual = this.plainText(actual));
        if (plainTextDiff.isEmpty()) {
            return plainTextDiff;
        }
        AssociativeArrays.Builder cipherText = AssociativeArrays.builder();
        for (String key : plainTextDiff) {
            String actualValue;
            String value = plainTextDiff.get(key);
            if (ConfigurationFilesBase.isPassword(key) && this.isObfuscated(actualValue = actual.get(key))) {
                value = this.cipherText(value);
            }
            cipherText.add(key, value);
        }
        return cipherText.build();
    }

    private String cipherText(String value) {
        return "@" + Passwords.goingOut(value);
    }

    private boolean equals(AssociativeArray<String, String> expected, AssociativeArray<String, String> actual) {
        AssociativeArray<String, String> plainTextExpected = this.plainText(expected);
        AssociativeArray<String, String> plainTextActual = this.plainText(actual);
        return plainTextExpected.equals(plainTextActual);
    }

    private AssociativeArray<String, String> plainText(AssociativeArray<String, String> input) {
        AssociativeArrays.Builder plainText = AssociativeArrays.builder();
        for (String key : input) {
            String value = input.get(key);
            if (ConfigurationFilesBase.isPassword(key)) {
                value = this.plainText(value);
            }
            plainText.add(key, value);
        }
        return plainText.build();
    }

    private String plainText(String value) {
        if (this.isObfuscated(value)) {
            return Passwords.comingIn(value.substring(1));
        }
        return value;
    }

    private boolean isObfuscated(String value) {
        return value.startsWith("@");
    }

    private Set<String> removed(Iterable<String> existing, Iterable<String> modified) {
        TreeSet<String> removed = new TreeSet<String>();
        Iterables.add(removed, existing);
        TreeSet mods = new TreeSet();
        Iterables.add(mods, modified);
        removed.removeAll(mods);
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void teardown() {
        this.confs.clear();
        Map<String, List<ConfigurationEventListener>> map = this.listeners;
        synchronized (map) {
            this.listeners.clear();
        }
    }

    private void changed(String name) {
        List<ConfigurationEventListener> listeners = this.listeners.get(name);
        if (listeners != null) {
            for (ConfigurationEventListener listener : listeners) {
                this.changed(name, listener);
            }
        }
        this.checkDefaultChanged(name);
    }

    private void changed(String name, ConfigurationEventListener listener) {
        if (ConfigurationFolder.INSTANCE.setup()) {
            listener.configurationChanged(name, new ConfigurationFile(name));
        }
    }

    private void checkDefaultChanged(String name) {
        if ("defaults".equals(name)) {
            for (String confName : this.listeners.keySet()) {
                if ("defaults".equals(confName)) continue;
                this.changed(confName);
            }
        }
    }

    private File defaultsLocation(String name) {
        return Files.file(this.location, name + FILE_SUFFIX);
    }

    private void ensureDefaultsExist(String name) {
        File defaults = this.defaultsLocation(name);
        if (!defaults.exists()) {
            Files.mkdirs(this.folder());
            this.write(defaults, AsAssociativeArray.asAssociativeArray(ConfigurationFilesBase.shippedDefaults()));
        }
    }

    private File file(String name) {
        if ("defaults".equals(name)) {
            return this.defaultsLocation("defaults");
        }
        return Files.file(this.folder(), name + FILE_SUFFIX);
    }

    private File folder() {
        return Files.file(this.location, CONF_FOLDER);
    }

    private AssociativeArray<String, String> values(String name) {
        return this.confs.apply(name);
    }

    private void write(File file, AssociativeArray<String, String> values) {
        try {
            Properties properties = AssociativeArrays.asProperties(values);
            if (!ConfigurationFilesBase.checkForPasswords(properties, file)) {
                ConfigFiles.save(properties, file);
            }
        }
        catch (IOException e) {
            this.log.severe("Error writing to: " + file.getAbsolutePath() + ", " + e.getMessage());
            throw UnrecoverableException.unrecoverable(e);
        }
    }

    static Configuration shippedDefaults() {
        Object shippedDefaults = null;
        try {
            PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(ConfigurationFilesBase.shippedDefaultsContents());
            return propertiesConfiguration;
        }
        catch (IOException e) {
            throw UnrecoverableException.unrecoverable(e);
        }
        finally {
            Closeables.close(shippedDefaults);
        }
    }

    static InputStream shippedDefaultsContents() {
        return ConfigurationFiles.class.getResourceAsStream("defaults.xml");
    }

    private static boolean checkForPasswords(Properties properties, File file) throws IOException {
        boolean modified = false;
        for (String name : Iterables.transform(properties.keySet(), Iterators.AS_STRING)) {
            String value = properties.getProperty(name);
            if (!ConfigurationFilesBase.isPassword(name) || !value.startsWith("!")) continue;
            value = value.substring(1);
            value = "@" + Passwords.goingOut(value);
            properties.put(name, value);
            modified = true;
        }
        if (modified) {
            ConfigFiles.save(properties, file);
        }
        return modified;
    }

    private static boolean isPassword(String name) {
        return name.endsWith(".password");
    }

    private static AssociativeArray<String, String> read(File file) {
        if (file.exists()) {
            SortedProperties properties = new SortedProperties();
            try {
                ConfigFiles.load(properties, file);
                ConfigurationFilesBase.checkForPasswords(properties, file);
                ConfigFiles.FromProperties values = new ConfigFiles.FromProperties(properties);
                return values;
            }
            catch (IOException e) {
                throw UnrecoverableException.unrecoverable(e);
            }
        }
        return null;
    }

    private final class ReadConfiguration
    implements Transform<String, AssociativeArray<String, String>> {
        private ReadConfiguration() {
        }

        @Override
        public AssociativeArray<String, String> apply(String name) {
            File file = ConfigurationFilesBase.this.file(name);
            AssociativeArray values = ConfigurationFilesBase.read(file);
            return values;
        }
    }

    private static final class IsConfigurationFile
    implements FileFilter {
        private IsConfigurationFile() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(ConfigurationFilesBase.FILE_SUFFIX);
        }
    }

    private static final class ConfigurationName
    implements Transform<File, String> {
        private ConfigurationName() {
        }

        @Override
        public String apply(File x) {
            String name = x.getName();
            name = name.substring(0, name.length() - ConfigurationFilesBase.FILE_SUFFIX.length());
            return name;
        }
    }

    private final class ConfigurationFile
    extends ConfigurationBase
    implements AssociativeArrays.MergedArray<String, String> {
        private final String name;

        ConfigurationFile(String name) {
            this.name = name;
        }

        @Override
        public AssociativeArray<String, String> child() {
            AssociativeArray confValues = ConfigurationFilesBase.this.values(this.name);
            return confValues;
        }

        @Override
        protected AssociativeArray<String, String> values() {
            AssociativeArray inheritedValues = null;
            if (!"defaults".equals(this.name)) {
                inheritedValues = ConfigurationFilesBase.this.values("defaults");
            }
            AssociativeArray<String, String> childValues = this.child();
            return AssociativeArrays.merge(childValues, inheritedValues);
        }
    }
}

