/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.config;

import oracle.dbtools.common.config.ConfigurationEventListener;
import oracle.dbtools.common.config.ConfigurationsProviders;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.plugin.api.conf.Configuration;

public class GlobalConfiguration
implements Configuration {
    private static final GlobalConfiguration INSTANCE = new GlobalConfiguration();
    private static final Log LOG = Log.get(GlobalConfiguration.class);

    private GlobalConfiguration() {
    }

    public void addListener(ConfigurationEventListener listener) {
        ConfigurationsProviders.instance().addListener("defaults", listener);
    }

    public boolean exists() {
        return ConfigurationsProviders.instance().exists("defaults");
    }

    public String get(String name) {
        return GlobalConfiguration.conf().get(name);
    }

    public String get(String name, String defaultValue) {
        try {
            return GlobalConfiguration.conf().get(name, defaultValue);
        }
        catch (IllegalStateException e) {
            if (defaultValue == null) {
                throw e;
            }
            LOG.finest(e);
            return defaultValue;
        }
    }

    public String getPassword(String name) {
        return GlobalConfiguration.conf().getPassword(name);
    }

    public Iterable<String> propertyNames() {
        return GlobalConfiguration.conf().propertyNames();
    }

    public static GlobalConfiguration globalConfiguration() {
        return INSTANCE;
    }

    private static Configuration conf() {
        Configuration defaults = ConfigurationsProviders.instance().get("defaults");
        if (defaults == null) {
            throw new IllegalStateException("No default configuration found");
        }
        return defaults;
    }
}

