/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.concurrent;

import java.security.SecureRandom;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import oracle.dbtools.common.concurrent.RetryContext;
import oracle.dbtools.common.logging.GlobalLog;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.common.util.TimeDuration;
import oracle.dbtools.plugin.api.logging.Log;

public final class RetryStrategy {
    private final long backOffInterval;
    private final RandomNumberGenerator jitterSource;
    private final Log log;
    private final long maximumInterval;
    private final Selector<Throwable> retryableExceptions;
    private final int retryCount;
    private static final long DEFAULT_BACK_OFF_INTERVAL = 0L;
    private static final Selector<Throwable> DEFAULT_EXCEPTION_SELECTOR = new AllExceptionsAreRetryable();
    private static final Log DEFAULT_LOG = GlobalLog.getInstance();
    private static final int DEFAULT_RETRY_COUNT = 0;

    public RetryStrategy(Log log, int retryCount, long backOffInterval, long maximumInterval, RandomNumberGenerator jitterSource, Selector<Throwable> retryableExceptions) {
        this.log = log;
        this.retryCount = retryCount;
        this.backOffInterval = backOffInterval;
        this.maximumInterval = maximumInterval;
        this.jitterSource = jitterSource;
        this.retryableExceptions = retryableExceptions;
    }

    public <V> V execute(Callable<V> task) throws Exception {
        RetryContext retries = this.start();
        while (true) {
            retries.attempt();
            try {
                V computed = task.call();
                retries.succeeded();
                return computed;
            }
            catch (Exception error) {
                if (!retries.errorRaised(error) && retries.retry()) continue;
                throw retries.lastError();
            }
            break;
        }
    }

    public Builder modify() {
        return new Builder(this);
    }

    RetryContext start() {
        return new RetryContext(this.log, this.retryCount, this.backOffInterval, this.maximumInterval, this.jitterSource, this.retryableExceptions);
    }

    static /* synthetic */ Log access$700() {
        return DEFAULT_LOG;
    }

    static /* synthetic */ Selector access$800() {
        return DEFAULT_EXCEPTION_SELECTOR;
    }

    private static final class SecureRandomGenerator
    implements RandomNumberGenerator {
        private final SecureRandom rng = new SecureRandom();

        private SecureRandomGenerator() {
        }

        @Override
        public long next(long n) {
            if (n > 0L) {
                long bits;
                long val;
                byte[] byteArray = new byte[8];
                do {
                    this.rng.nextBytes(byteArray);
                    bits = 0L;
                    for (byte b : byteArray) {
                        bits = bits << 8 | (long)b & 0xFFL;
                    }
                } while ((bits &= Long.MAX_VALUE) - (val = bits % n) + (n - 1L) < 0L);
                return val;
            }
            throw new IllegalArgumentException();
        }
    }

    public static interface RandomNumberGenerator {
        public long next(long var1);
    }

    public static final class Builder {
        private long backOffInterval = 0L;
        private RandomNumberGenerator jitterSource = new SecureRandomGenerator();
        private Log log = RetryStrategy.access$700();
        private long maximumInterval = -1L;
        private Selector<Throwable> retryableExceptions = RetryStrategy.access$800();
        private int retryCount = 0;

        public Builder() {
        }

        public Builder(RetryStrategy existing) {
            this();
            this.backOffInterval = existing.backOffInterval;
            this.jitterSource = existing.jitterSource;
            this.maximumInterval = existing.maximumInterval;
            this.retryableExceptions = existing.retryableExceptions;
            this.retryCount = existing.retryCount;
            this.log = existing.log;
        }

        public Builder backOffInterval(TimeDuration backOffInterval) {
            this.backOffInterval = this.toMilliseconds(backOffInterval);
            return this;
        }

        public RetryStrategy build() {
            long maximumInterval = this.maximumInterval <= 0L ? this.backOffInterval * 10L : this.maximumInterval;
            return new RetryStrategy(this.log, this.retryCount, this.backOffInterval, maximumInterval, this.jitterSource, this.retryableExceptions);
        }

        public Builder jitterSource(RandomNumberGenerator jitterSource) {
            this.jitterSource = jitterSource;
            return this;
        }

        public Builder log(Log log) {
            this.log = log;
            return this;
        }

        public Builder maximumInterval(TimeDuration maximumInterval) {
            TimeDuration duration = maximumInterval;
            this.maximumInterval = this.toMilliseconds(duration);
            return this;
        }

        public Builder retryableExceptions(Selector<Throwable> retryableExceptions) {
            this.retryableExceptions = retryableExceptions;
            return this;
        }

        public Builder retryCount(int retryCount) {
            this.retryCount = retryCount;
            return this;
        }

        long toMilliseconds(TimeDuration duration) {
            return TimeUnit.MILLISECONDS.convert(duration.duration(), duration.unit());
        }
    }

    public static class AllExceptionsAreRetryable
    implements Selector<Throwable> {
        @Override
        public Boolean apply(Throwable x) {
            return Boolean.TRUE;
        }
    }
}

